﻿// See https://aka.ms/new-console-template for more information
using Syncfusion.Pdf;
using Syncfusion.Pdf.Graphics;
using System.Reflection;
using System.Threading.Channels;

var parallelCount = 5;
var numberOfDocuments = 10000;
var rng = new Random();

Console.WriteLine($"Degree of parallelism (defaults to {parallelCount}): ");
var parallelCountInput = Console.ReadLine();
if (!string.IsNullOrWhiteSpace(parallelCountInput))
    _ = int.TryParse(parallelCountInput, out parallelCount);

Console.WriteLine($"Number of documents (defaults to {numberOfDocuments}): ");
var numberOfDocumentsInput = Console.ReadLine();
if (!string.IsNullOrWhiteSpace(numberOfDocumentsInput))
    _ = int.TryParse(numberOfDocumentsInput, out numberOfDocuments);

var channel = Channel.CreateBounded<Guid>(new BoundedChannelOptions(parallelCount)
{
    Capacity = parallelCount,
    SingleWriter = true,
    SingleReader = false
});

var createSucceeded = 0;
var createFailed = 0;
var consumer = new Task[parallelCount];
//var font = new PdfStandardFont(PdfFontFamily.Helvetica, 20);
var font = new PdfTrueTypeFont(typeof(Program).GetTypeInfo().Assembly.GetManifestResourceStream("SyncfusionPdfMTExample.Krub-Medium.ttf"), 10, PdfFontStyle.Regular);
for (var i = 0; i < parallelCount; i++)
{
    // an instance per "thread" is not working either
    //var font = new PdfTrueTypeFont(typeof(Program).GetTypeInfo().Assembly.GetManifestResourceStream("SyncfusionPdfMTExample.Krub-Medium.ttf"), 10, PdfFontStyle.Regular);
    async Task ConsumerTask(Channel<Guid> innerChannel)
    {
        while (await innerChannel.Reader.WaitToReadAsync())
        {
            if (innerChannel.Reader.TryRead(out var channelData))
            {
                try
                {
                    PdfDocument.EnableThreadSafe = true;
                    var pdfDocument = new PdfDocument();
                    var page = pdfDocument.Pages.Add();
                    // if defined here it is working
                    //var font = new PdfTrueTypeFont(typeof(Program).GetTypeInfo().Assembly.GetManifestResourceStream("SyncfusionPdfMTExample.Krub-Medium.ttf"), 10, PdfFontStyle.Regular);
                    var textElement = new PdfTextElement(channelData.ToString(), font);
                    textElement.Draw(page.Graphics);
                    using var memoryStream = new MemoryStream();
                    pdfDocument.Compression = PdfCompressionLevel.Normal;
                    pdfDocument.Save(memoryStream);
                    Interlocked.Increment(ref createSucceeded);
                }
                catch (Exception exception)
                {
                    Interlocked.Increment(ref createFailed);
                    Console.WriteLine(exception);
                }
            }
        }
    }

    consumer[i] = Task.Run(() => ConsumerTask(channel));
}

var tenPercent = numberOfDocuments / 100;
for (int i = 1; i <= numberOfDocuments; i++)
{
    if (await channel.Writer.WaitToWriteAsync())
        await channel.Writer.WriteAsync(Guid.NewGuid());
    if (i % tenPercent == 0)
        Console.WriteLine($"started: {i}");
}

channel.Writer.Complete();
await Task.WhenAll(consumer);

Console.WriteLine("Done");