﻿using System;
using System.Collections;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Threading;
using System.Threading.Tasks;

namespace Reproduction
{
    public sealed class Program
    {
        public static void Main(string[] args)
        {
            // Pre-load everything from our sample document.
            var buffer = File.ReadAllBytes(@$"Lorem Ipsum.docx");

            // Create 40 tasks that we can run in parallel.
            var resetEvent = new ManualResetEventSlim();
            var tasks = Enumerable.Range(0, 40).AsParallel().Select(i => Task.Run(() =>
                {
                    using var ms = new MemoryStream(buffer);
                    resetEvent.Set();
                    return Syncfusion.EJ2.DocumentEditor.WordDocument.Load(ms, Syncfusion.EJ2.DocumentEditor.FormatType.Docx);
                }))
                .ToArray();
            
            // All tasks have been created, let's run them.
            resetEvent.Set();
            Task.WhenAll(tasks).Wait();

            // Check each loaded document to see how many styles have been loaded.
            // As this document is supposed to have 16 styles, if we get less then we've bumped into the bug.
            foreach (var task in tasks)
            {
                // While this isn't officially supported, this is the simplest way to reproduce and observe the issue.
                // In normal usage, this WordDocument would be transformed into a regular, editable document where the styles are exposed.
                var styles = task.Result.GetType().GetProperty("Styles", BindingFlags.Instance | BindingFlags.NonPublic)!.GetValue(task.Result) as IList;
                if (styles.Count != 16)
                {
                    System.Console.WriteLine("Bug! Got the wrong number of styles.");
                    Environment.Exit(-1);
                }
                System.Console.WriteLine("Loaded a document.");
            }

            System.Console.WriteLine("Everything went well.");
        }
    }
}
