﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace GridSplitter_357544
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
            gridSplitter.Loaded += GridSplitter_Loaded;
            gridSplitter.LayoutUpdated += GridSplitter_LayoutUpdated;
        }

        private void GridSplitter_Loaded(object sender, RoutedEventArgs e)
        {
            gridSplitter.MoveSplitter(this.Width);
        }

        private void GridSplitter_LayoutUpdated(object sender, EventArgs e)
        {
            if (!gridSplitter.IsLoaded)
                return;
            Button LeftButton = gridSplitter.Template.FindName("PART_Left", gridSplitter) as Button;
            Button RightButton = gridSplitter.Template.FindName("PART_Right", gridSplitter) as Button;
            if(LeftButton != null && RightButton != null)
            {
                LeftButton.Click += LeftButton_Click; 
                RightButton.Click += RightButton_Click;
                gridSplitter.LayoutUpdated -= GridSplitter_LayoutUpdated;
            }
        }

        private void RightButton_Click(object sender, RoutedEventArgs e)
        {
            gridSplitter.MoveSplitter(this.Width/2);
        }

        private void LeftButton_Click(object sender, RoutedEventArgs e)
        {
            gridSplitter.MoveSplitter(-this.Width/2);
        }

    }
}
