using BlazorApp2.Data;
using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Web;
using Microsoft.AspNetCore.Localization;
using Syncfusion.Blazor;
using System.Globalization;

var builder = WebApplication.CreateBuilder(args);

// Add services to the container.
builder.Services.AddRazorPages();
builder.Services.AddServerSideBlazor();
builder.Services.AddSingleton<WeatherForecastService>();

builder.Services.AddSyncfusionBlazor();
#region Localization
// Set the resx file folder path to access
builder.Services.AddLocalization(options => options.ResourcesPath = "Resources");
// Register the Syncfusion locale service to customize the  SyncfusionBlazor component locale culture
builder.Services.AddSingleton(typeof(ISyncfusionStringLocalizer), typeof(IMX.Web.Controllers.SyncfusionLocalizer));
builder.Services.Configure<RequestLocalizationOptions>(options =>
{
  // Define the list of cultures your app will support
  var supportedCultures = new List<CultureInfo>()
            {
                //new CultureInfo("en-US"),
                //new CultureInfo("de"),
                //new CultureInfo("fr-CH"),
                new CultureInfo("zh")
            };
  // Set the default culture
  options.DefaultRequestCulture = new RequestCulture("zh");
  options.SupportedCultures = supportedCultures;
  options.SupportedUICultures = supportedCultures;
});

#endregion

var app = builder.Build();

// Configure the HTTP request pipeline.
if (!app.Environment.IsDevelopment())
{
    app.UseExceptionHandler("/Error");
    // The default HSTS value is 30 days. You may want to change this for production scenarios, see https://aka.ms/aspnetcore-hsts.
    app.UseHsts();
}

app.UseHttpsRedirection();

app.UseStaticFiles();

app.UseRouting();

app.MapBlazorHub();
app.MapFallbackToPage("/_Host");

app.Run();
