﻿using Syncfusion.UI.Xaml.Gantt;
using Syncfusion.UI.Xaml.TreeGrid;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;

namespace sfgrid
{
    public class SelectorClass : StyleSelector
    {
        public Style RowStyle1 { get; set; }
        public Style RowStyle2 { get; set; }
        public Style RowStyle3 { get; set; }
        protected override Style SelectStyleCore(object item, DependencyObject container)
        {

            var row = (item as TreeDataRowBase).RowData;
            int id = 0;
            if (int.TryParse((row as TaskDetail).ID, out id))
            {
                if (id <= 5)
                {
                    return RowStyle1;
                }
                if (id > 5 && id <= 10)
                {
                    return RowStyle2;
                }
            }

            return RowStyle3;

        }
    }
}
