﻿using Syncfusion.UI.Xaml.Gantt;
using Syncfusion.UI.Xaml.TreeGrid;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Runtime.InteropServices.WindowsRuntime;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;

// The Blank Page item template is documented at https://go.microsoft.com/fwlink/?LinkId=402352&clcid=0x409

namespace sfgrid
{
    /// <summary>
    /// An empty page that can be used on its own or navigated to within a Frame.
    /// </summary>
    public sealed partial class MainPage : Page
    {
        public ObservableCollection<TaskDetail> TaskCollection { get; set; }
        public MainPage()
        {
            this.InitializeComponent();
            TaskCollection=GetData();

            LoadHolidays();
        }

        private void LoadHolidays()
        {
            GanttControl.Holidays = new GanttHolidayCollection();
            GanttControl.Holidays.Add(
                new GanttHoliday
                {
                    Background = new SolidColorBrush(Colors.PeachPuff),
                    Day = new DateTime(2014,3,30)
                });
        }

        private void SfGantt_Loaded(object sender, RoutedEventArgs e)
        {
            // Reflect the GanttGrid property in the GanttControl.
            PropertyInfo ganttGridPropertyInfo = this.GanttControl.GetType()
                .GetProperty("Grid", BindingFlags.Instance | BindingFlags.NonPublic);
            GanttGrid ganttGrid = ganttGridPropertyInfo.GetValue(this.GanttControl) as GanttGrid;
            ganttGrid.ShowRowHeader = false;

            // Define the controls in this template for the custom column.
            DataTemplate cellTemplate = this.RootGrid.Resources["CellTemplate"] as DataTemplate;
            DataTemplate VendorName = this.RootGrid.Resources["VendorName"] as DataTemplate;
            DataTemplate Header = this.RootGrid.Resources["Header"] as DataTemplate;
            ganttGrid.RowStyleSelector = StyleSelector;
            foreach (TreeGridColumn column in ganttGrid.Columns)
            {
                if (column.HeaderText != "Name")
                {
                    column.TextAlignment = TextAlignment.Center;
                }
            }


            // TreeGridTemplateColumn is used to add the custom column for the GanttGrid.
            ganttGrid.Columns.Add(new TreeGridTemplateColumn()
            {
                HeaderText = "Button",
                HeaderTemplate = VendorName,
                CellTemplate = cellTemplate,
                AllowEditing = false
            });



            // TreeGridTemplateColumn is used to add the custom column for the GanttGrid.
            ganttGrid.Columns.Insert(2, new TreeGridTemplateColumn()
            {
                HeaderText = "Vendor Name",
                HeaderTemplate = Header,
                CellTemplate = VendorName,
                AllowEditing = false
            });

            foreach (TreeGridColumn column in ganttGrid.Columns)
            {
                if (column.HeaderText != "Name")
                {
                    column.TextAlignment = TextAlignment.Center;
                }
            }

        }


        public ObservableCollection<TaskDetail> GetData()
        {
            ObservableCollection<TaskDetail> Schedule = new ObservableCollection<TaskDetail>();

            Schedule.Add(new TaskDetailExtention
            {
                Name = "Project Schedule",
                ID = "1",
                VendorName = "Barlouey",
                StartDate = new DateTime(2014, 3, 28),
                FinishDate = new DateTime(2014, 3, 29)
            }); ;

            //ObservableCollection<TaskDetail> ScheduleProcess = new ObservableCollection<TaskDetail>();

            Schedule.Add(new TaskDetailExtention
            {
                Name = "Planning",
                ID = "1333333",
                VendorName ="Here is my vendor with a very long name",
                StartDate = new DateTime(2014, 3, 30),
                FinishDate = new DateTime(2014, 4, 2)
            });

            Schedule.Add(new TaskDetail
            {
                StartDate = new DateTime(2014, 3, 30),
                FinishDate = new DateTime(2014, 4, 2),
                Name = "Design",
                ID = "7"
            });
            List<TaskRelationship> relationships = new List<TaskRelationship>();
            relationships.Add(new TaskRelationship { ID = "7", Relationship = Relationship.FinishToStart, Name = "kabob", Offset = 7.0 });

            Schedule.Add(new TaskDetail
            {
                StartDate = new DateTime(2014, 4, 2),
                FinishDate = new DateTime(2014, 4, 7),
                Name = "Implementation Phase",
                ID = "12",
                Predecessors = relationships
            });

            Schedule.Add(new TaskDetail
            {
                StartDate = new DateTime(2014, 4, 7),
                FinishDate = new DateTime(2014, 4, 12),
                Name = "Integration",
                ID = "37"
            });

            Schedule.Add(new TaskDetail
            {
                StartDate = new DateTime(2014, 4, 12),
                FinishDate = new DateTime(2014, 4, 17),
                Name = "Final Testing",
                ID = "38"
            });



            ObservableCollection<TaskDetail> Planning = new ObservableCollection<TaskDetail>();

            Planning.Add(new TaskDetail
            {
                StartDate = new DateTime(2014, 3, 25),
                FinishDate = new DateTime(2014, 3, 30),
                Name = "Plan timeline",
                ID = "3",
                Progress = 100
            });

            Planning.Add(new TaskDetail
            {
                StartDate = new DateTime(2014, 3, 25),
                FinishDate = new DateTime(2014, 3, 30),
                Name = "Plan budget",
                ID = "4",
                Progress = 100
            });

            Planning.Add(new TaskDetail
            {
                StartDate = new DateTime(2014, 3, 25),
                FinishDate = new DateTime(2014, 3, 30),
                Name = "Allocate resources",
                ID = "5",
                Progress = 100
            });

            Planning.Add(new TaskDetail
            {
                StartDate = new DateTime(2014, 3, 30),
                FinishDate = new DateTime(2014, 3, 30),
                Name = "Planning complete",
                ID = "6",
                Progress = 100
            });

            return Schedule;
        }

        private void Button_Click(object sender, RoutedEventArgs e)
        {
            Button    button = sender as Button;    
            var ctx = (TaskDetail)button.DataContext;
            TheViewModel.Button_Click(ctx, e); 
            

        }

        private void GanttControl_TaskRelationshipEstablished(object sender, TaskRelationshipEventArgs e)
        {
            var item = e.EndTask as TaskDetailExtention;
        }
    }


}
