﻿
using System.Collections.ObjectModel;
using System.ComponentModel;

namespace SyncFusionWinform
{
    public class Contract : INotifyPropertyChanged
    {
        public string FilesName { get; set; }
        public string Status { get; set; }
        public ObservableCollection<Invoice> Invoices { get; set; }

        public event PropertyChangedEventHandler PropertyChanged;

        public static ObservableCollection<Contract> GetSample()
        {
            return new ObservableCollection<Contract>() {
            new Contract()
            {
                FilesName="457646",
                Status ="OK",
                Invoices = new ObservableCollection<Invoice>()
            {
                new Invoice(){Amount =1234,Number = "777"}
            }
            }
            };
        }
    }
}
