﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Syncfusion.DocIO;
using Syncfusion.DocIO.DLS;
using System.IO;
using System.Drawing;
using Syncfusion.DocToPDFConverter;
using Syncfusion.Pdf;

namespace WebApplication2
{
    public partial class MainPage : System.Web.UI.Page
    {
        protected void OnButtonClicked(object sender, EventArgs e)
        {

            WordDocument document = new WordDocument(Server.MapPath(@"data/test.docx"), FormatType.Docx);
			document.MailMerge.MergeField += MailMerge_MergeField;
			document.MailMerge.Execute(new[] {
				"test",
			}, new[] {
				@"<p>BR Test<br />BR Test<br />BR Test<br />BR Test<br />BR Test</p>
					<p>P tag</p>
					<p>P tag</p>
					<p>P tag</p>
				<p>P tag</p>"
			});
			document.UpdateDocumentFields();

			/******************************************************************************************/
			/**** UNCOMMENT THIS LINE AND ADD AN APPROPRIATE SAVE PATH TO SEE WORD DOCUMENT OUTPUT ****/

			//document.Save("e:\\test.docx", FormatType.Docx);

			/******************************************************************************************/

			DocToPDFConverter converter = new DocToPDFConverter();
            PdfDocument pdfDocument = converter.ConvertToPDF(document);

            Response.ContentType = "application/pdf";
            Response.AddHeader("content-disposition", "inline; filename=test.pdf");
            pdfDocument.Save(Response.OutputStream);

        }

		private void MailMerge_MergeField(object sender, MergeFieldEventArgs args)
		{
			if (args.FieldName.Equals("test"))
			{
				WParagraph paragraph = args.CurrentMergeField.OwnerParagraph;
				int paraIndex = paragraph.OwnerTextBody.ChildEntities.IndexOf(paragraph);
				int paraItemIndex = paragraph.ChildEntities.IndexOf(args.CurrentMergeField);
				paragraph.OwnerTextBody.InsertXHTML(args.FieldValue.ToString(), paraIndex, paraItemIndex);
				args.Text = string.Empty;
			}
		}

	}
}