import { Injectable } from '@angular/core';
import { Http } from '@angular/http';
import { DataResult, DataStateChangeEventArgs } from '@syncfusion/ej2-grids';
import { Observable, Subject } from 'rxjs';
import 'rxjs/add/observable/of';
import 'rxjs/add/operator/map'

@Injectable({
  providedIn: 'root'
})
export class MyDataService extends Subject<DataStateChangeEventArgs>{

  private BASE_URL = 'https://js.syncfusion.com/demos/ejServices/Wcf/Northwind.svc/Orders';

  constructor(private http: Http) {
    super();
  }

  public execute(state: any) {

    this.getData(state).subscribe(x => super.next(x));
  }

  protected getData(state: any): Observable<DataStateChangeEventArgs> {

    const pageQuery = `$skip=${state.skip}&$top=${state.take}`;
    let sortQuery = '';
    const d = 'd';
    const results = 'results';
    const count = '__count';

    return this.http
      .get(`${this.BASE_URL}?${pageQuery}${sortQuery}&$inlinecount=allpages&$format=json`)
      .map((response: any) => response.json())
      .map((response: any) => ({
        result: response[d][results]
        // count: parseInt(response[d][count], 10)
      } as DataResult))
      .pipe((data: any) => data);
  }

}
