import { MyDataService } from './../services/my-data.service';
import { Component, OnInit } from '@angular/core';
import { DataStateChangeEventArgs, InfiniteScrollService } from '@syncfusion/ej2-angular-grids';

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css'],
  providers: [InfiniteScrollService]
})
export class AppComponent implements OnInit {
  title = 'syncfusion-infinite-scrolling';

  public pageSettings: Object;

  constructor(
    public dataService: MyDataService
  ) {}

  public ngOnInit() {

    this.pageSettings = { pageSize: 50 };

    let state = { skip: 0, take: 20 };
    this.dataService.execute(state);
  }

  public dataStateChange(state: DataStateChangeEventArgs): void {
    this.dataService.execute(state);
  }
}
