﻿using Syncfusion.Pdf.Parsing;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace PdfFields
{
    class Program
    {
        static void Main(string[] args)
        {
            // Feilds are empty
            using (PdfLoadedDocument pdfDocument = new PdfLoadedDocument("Sample.pdf", true))
            {
                PdfLoadedForm pdfForm = pdfDocument.Form;
                if (pdfForm != null)
                {
                    PdfLoadedFormFieldCollection pdfFormFields = pdfForm.Fields;
                    if (pdfFormFields != null)
                    {
                        foreach (PdfLoadedTextBoxField field in pdfFormFields.OfType<PdfLoadedTextBoxField>())
                        {
                            field.Text = field.Text;
                        }

                        // Now fields are filled with strings like 1234567890
                        pdfDocument.Save();
                    }
                }

                pdfDocument.Close(true);
            }

            Process.Start("Sample.pdf");
        }
    }
}
