﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Syncfusion.DocIO;
using Syncfusion.DocIO.DLS;
using System.Drawing;
using Syncfusion.OfficeChart;

namespace DocIOChart
{
  class Program
  {
    static void Main(string[] args)
    {
      WordDocument document = new WordDocument();
      MinPie(document, false);
      document.Save(@"C:\temp\PieSample.docx", FormatType.Docx);
      document.Close();
      document = new WordDocument();
      MinPie(document, true);
      document.Save(@"C:\temp\DoughnutSample.docx", FormatType.Docx);
      document.Close();
    }

    private static void MinPie(WordDocument document, Boolean isDoughnut)
    {
      IWSection sec = document.AddSection();
      IWParagraph firstParagraph = sec.AddParagraph();
      IWParagraph paragraph = sec.AddParagraph();
      WChart chart = paragraph.AppendChart(400f, 300f);
      chart.ChartType = isDoughnut ? OfficeChartType.Doughnut : OfficeChartType.Pie;
      chart.ChartTitle = "Sandwich Fillings";
      chart.ChartData.SetValue(1, 1, "Cheese");
      chart.ChartData.SetValue(1, 2, 1);
      chart.ChartData.SetValue(2, 1, "Tuna");
      chart.ChartData.SetValue(2, 2, 2);
      chart.ChartData.SetValue(3, 1, "Chicken");
      chart.ChartData.SetValue(3, 2, 3);
      IOfficeChartSerie pieSeries = chart.Series.Add("Sandwich Fillings");
      pieSeries.Values = chart.ChartData[1, 2, 3, 2];
      pieSeries.DataPoints.DefaultDataPoint.DataLabels.IsCategoryName = true;
      pieSeries.DataPoints.DefaultDataPoint.DataLabels.Position = OfficeDataLabelPosition.Outside;
      chart.ChartArea.Fill.ForeColor = Color.White;
      chart.PlotArea.Fill.ForeColor = Color.White;
      chart.ChartArea.Border.LinePattern = OfficeChartLinePattern.None;
      chart.Legend.Position = OfficeLegendPosition.Bottom;
      chart.PrimaryCategoryAxis.CategoryLabels = chart.ChartData[1, 1, 3, 1];
    }


  }
}
