﻿using BlazorWASMHosted.Shared.Data;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Primitives;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Threading.Tasks;

// For more information on enabling Web API for empty projects, visit https://go.microsoft.com/fwlink/?LinkID=397860

namespace BlazorWASMHosted.Server.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class DefaultController : ControllerBase
    {
        public OrderDataAccessLayer OrderService = new OrderDataAccessLayer();
        // GET: api/Default
        [HttpGet]
        public async Task<object> Get(int? code)
        {
            var data = OrderService.GetAllOrders().AsQueryable();
            var queryString = Request.Query;
            string grid = queryString["ej2grid"];
            string sort = queryString["$orderby"];   //sorting      
            string filter = queryString["$filter"];
            string auto = queryString["$inlineCount"];
            if (filter != null) // to handle filter opertaion
            {
                if (filter.Contains("substring"))//searching 
                {
                    var key = filter.Split(new string[] { "'" }, StringSplitOptions.None)[1];
                    data = data.Where(fil => fil.CustomerID.ToString().Contains(key.ToUpper())
                                            || fil.EmployeeID.ToString().Contains(key)
                                            || fil.OrderID.ToString().Contains(key));
                }
                else
                {
                    var newfiltersplits = filter;
                    var filtersplits = newfiltersplits.Split('(', ')', ' ');
                    var filterfield = filtersplits[1];
                    var filtervalue = filtersplits[3];

                    if (filtersplits.Length == 7)
                    {
                        if (filtersplits[2] == "tolower")
                        {
                            filterfield = filter.Split('(', ')', '\'')[3];
                            filtervalue = filter.Split('(', ')', '\'')[5];
                        }
                    }
                    switch (filterfield)
                    {
                        case "OrderID":
                            data = (from cust in data
                                    where cust.OrderID.ToString() == filtervalue.ToString()
                                    select cust);
                            break;
                        case "CustomerID":
                            data = (from cust in data
                                    where cust.CustomerID.ToLower().StartsWith(filtervalue.ToString())
                                    select cust);
                            break;
                        case "Freight":
                            data = (from cust in data
                                    where cust.EmployeeID.ToString() == filtervalue.ToString()
                                    select cust);
                            break;
                    }
                }
            }
            if (sort != null) //Sorting 
            {
                var sortfield = sort.Split(',');
                for (var i = sortfield.Length; i > 0; i--)
                {
                    var sortColumn = sortfield[i - 1].Split(" ");
                    var sorttype = sortColumn[0];
                    if (sortColumn.Length == 2)
                    {
                        switch (sorttype)
                        {
                            case "OrderID":
                                data = data.OrderByDescending(x => x.OrderID);
                                break;
                            case "CustomerID":
                                data = data.OrderByDescending(x => x.CustomerID);
                                break;
                            case "EmployeeID":
                                data = data.OrderByDescending(x => x.EmployeeID);
                                break;
                        }
                    }
                    else
                    {
                        switch (sorttype)
                        {
                            case "OrderID":
                                data = data.OrderBy(x => x.OrderID);
                                break;
                            case "CustomerID":
                                data = data.OrderBy(x => x.CustomerID);
                                break;
                            case "EmployeeID":
                                data = data.OrderBy(x => x.EmployeeID);
                                break;
                        }
                    }
                }
            }
            if (queryString.Keys.Contains("$inlinecount"))
            {
                StringValues Skip;
                StringValues Take;
                int skip = (queryString.TryGetValue("$skip", out Skip)) ? Convert.ToInt32(Skip[0]) : 0;
                int top = (queryString.TryGetValue("$top", out Take)) ? Convert.ToInt32(Take[0]) : data.Count();
                var count = data.Count();
                return new { Items = data.Skip(skip).Take(top), Count = count };
            }
            else
            {
                return data;
            }
        }
        //// POST: api/Default
        [HttpPost]
        public object Post([FromBody] Order value)
        {
            OrderService.AddOrder(value);
            return value;
        }

        //// PUT: api/Default/5
        [HttpPut]
        public object Put([FromBody] Order value)
        {
            OrderService.UpdateOrder(value);
            return value;
        }
        //// DELETE: api/ApiWithActions/5
        [HttpDelete("{id}")]
        public void Delete([FromBody] int id)
        {
            OrderService.DeleteOrder(id);
        }
    }
}
