import { ITooltipRenderEventArgs, SeriesModel } from '@syncfusion/ej2-charts';
import { ChartComponent } from '@syncfusion/ej2-angular-charts';
import { Component, OnInit } from '@angular/core';

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
})
export class AppComponent implements OnInit {
  public primaryXAxis: Object = {
    majorGridLines: { width: 0 },
    majorTickLines: { width: 0 },
    valueType: 'Category',
    interval: 1,
  };

  public primaryYAxis: Object = {
    majorTickLines: { width: 0 },
    lineStyle: { width: 0 },
    interval: 1,
  };

  public readonly tooltip: Object = {
    enable: true,
    shared: true,
  };

  public dataA = [
    { month: 'jan/2020', value: -4 },
    { month: 'fev/2020', value: -1 },
    { month: 'mar/2020', value: -2 },
    { month: 'abr/2020', value: -1 },
    { month: 'mai/2020', value: -2 },
    { month: 'jun/2020', value: -3 },
    { month: 'jul/2020', value: -1 },
    { month: 'ago/2020', value: -2 },
    { month: 'set/2020', value: -3 },
  ];
  public dataB = [
    { month: 'jan/2020', value: 2 },
    { month: 'fev/2020', value: 3 },
    { month: 'mar/2020', value: 4 },
    { month: 'abr/2020', value: 4 },
    { month: 'mai/2020', value: 3 },
    { month: 'jun/2020', value: 1 },
    { month: 'jul/2020', value: 2 },
    { month: 'ago/2020', value: 3 },
    { month: 'set/2020', value: 2 },
  ];

  constructor() {}

  ngOnInit(): void {}

  tooltipRender(args: ITooltipRenderEventArgs, chart: ChartComponent) {
    let template = '';
    chart.series.forEach((e: SeriesModel) => {
      template =
        template +
        `<div style="display:flex;width:100%;margin-bottom:6px">
          <div style="width:100%;text-align:left">
            <div style="height:9px;width:9px;border-radius:20px;border:1px solid #fff;float:left;margin-right:11px;background:${
              e['interior']
            }"
            ></div>
            ${e.name}:
          </div>
          <div style="text-align:right">
            ${e.dataSource[args.data.pointIndex].value}
          </div>
        </div>
        `;
    });
    args.template = `
    <div style="background:#1D1C1C;color:#fff;padding:10px 13px 3px 13px;width:160px;font-size:11px;margin:0 15px">
      ${template}
    </div>`;
  }
}
