﻿using System.ComponentModel;
using System.Runtime.CompilerServices;

namespace SyncfusionTreeviewDatasourceChangeIssue
{
    public class AppGroup : INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;
        
        private string _name;
        
        public string Name
        {
            get { return _name; }
            set
            {
                if (_name != value)
                {
                    _name = value;
                    OnPropertyChanged();
                }
            }
        }

        public List<PermissionGroup> PermissionGroups { get; set; } = new List<PermissionGroup>();

        public void OnPropertyChanged([CallerMemberName] string name = null)
        {
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(name));
        }
    }
    public class PermissionGroup : INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;

        private string _name;
        private string _displayName;
        private bool? _isAllowed;
        private List<PermissionGroup> _permissionGroups = new List<PermissionGroup>();

        public Guid Guid { get; set; } = Guid.NewGuid();

        public string Name
        {
            get { return _name; }
            set
            {
                if (_name != value)
                {
                    _name = value;
                    OnPropertyChanged();
                }
            }
        }

        public bool? IsAllowed
        {
            get
            {
                return _isAllowed;
            }
            set
            {
                if (_isAllowed != value)
                {
                    _isAllowed = value;

                    OnPropertyChanged();
                }
            }
        }

        public List<PermissionGroup> PermissionGroups
        {
            get { return _permissionGroups; }
            set
            {
                if (_permissionGroups != value)
                {
                    _permissionGroups = value;
                    OnPropertyChanged();
                }
            }
        }

        public void OnPropertyChanged([CallerMemberName] string name = null)
        {
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(name));
        }
    }
}
