﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace scheduler_resources.Controllers
{
    public class HomeController : Controller
    {
        public ActionResult Index()
        {
            ViewBag.datasource = GetResourceData();
            // datasource for room resources
            List<RoomResource> rooms = new List<RoomResource>();
            rooms.Add(new RoomResource { RoomText = "ROOM 1", Id = 1, RoomColor = "#cb6bb2" });
            rooms.Add(new RoomResource { RoomText = "ROOM 2", Id = 2, RoomColor = "#56ca85" });
            ViewBag.Rooms = rooms;
            // datasource for owner resources
            List<OwnerResource> owners = new List<OwnerResource>();
            owners.Add(new OwnerResource { OwnerText = "Nancy", Id = 1, OwnerGroupId = 1, OwnerColor = "#ffaa00" });
            owners.Add(new OwnerResource { OwnerText = "Steven", Id = 2, OwnerGroupId = 2, OwnerColor = "#f8a398" });
            ViewBag.Owners = owners;

            List<Leve1Resource> Level1 = new List<Leve1Resource>();
            Level1.Add(new Leve1Resource { Level1Text = "Text1L1", Id = 1, Level1GroupId = 1, Level1Color = "#ffaa00" });

      
            ViewBag.Level1 = Level1;

            List<Leve2Resource> Level2 = new List<Leve2Resource>();
            Level2.Add(new Leve2Resource { Level2Text = "Text1L2", Id = 1, Level2GroupId = 2, Level2Color = "#ffaa00" });
   
    
            ViewBag.Level2 = Level2;

            ViewBag.Resources = new string[] { "Rooms", "Owners", "Level1", "Level2" };
            return View();
        }
        public List<ResourceData> GetResourceData()
        {
            List<ResourceData> resourceData = new List<ResourceData>();

            resourceData.Add(new ResourceData
            {
                Id = 3,
                Subject = "Resource planning",
                StartTime = new DateTime(2018, 4, 1, 1, 0, 0),
                EndTime = new DateTime(2018, 4, 1, 5, 0, 0),
                IsAllDay = false,
                OwnerId = 2,
                RoomId = 2
            });
            return resourceData;
        }


        public class ResourceData
        {
            public int Id { get; set; }
            public string Subject { get; set; }
            public DateTime StartTime { get; set; }
            public DateTime EndTime { get; set; }
            public bool IsAllDay { get; set; }
            public int OwnerId { get; set; }
            public int RoomId { get; set; }

            public int Level1Id { get; set; }
            public int Level2Id { get; set; }
        }

        public class RoomResource
        {
            public string RoomText { set; get; }
            public int Id { set; get; }
            public string RoomColor { set; get; }
        }
        public class OwnerResource
        {
            public string OwnerText { set; get; }
            public int Id { set; get; }
            public string OwnerColor { set; get; }
            public int OwnerGroupId { set; get; }
        }

        public class Leve1Resource
        {
            public string Level1Text { set; get; }
            public int Id { set; get; }
            public string Level1Color { set; get; }
            public int Level1GroupId { set; get; }
        }

        public class Leve2Resource
        {
            public string Level2Text { set; get; }
            public int Id { set; get; }
            public string Level2Color { set; get; }
            public int Level2GroupId { set; get; }
        }
        public ActionResult About()
        {
            ViewBag.Message = "Your application description page.";

            return View();
        }

        public ActionResult Contact()
        {
            ViewBag.Message = "Your contact page.";

            return View();
        }
    }
}