import { Grid, Group, LazyLoadGroup } from '@syncfusion/ej2-grids';

Grid.Inject(Group, LazyLoadGroup);

const data = Array.from({ length: 10000 }, _ => {
  const row = {};
  for (let j = 0; j < 15; j++) {
    row[`col-${j}`] = `data-${Math.random()}`
  }
  return row
});

new Grid({
  height: '100%',
  width: '100%',
  allowGrouping: true,
  groupSettings: { enableLazyLoading: true },
  dataSource: data,
}, '#grid');
