﻿using SyncfusionSchedulerDeleteBug.DataAccess.Mock.Events;
using SyncfusionSchedulerDeleteBug.DataAccess.Workers;
using System;
using System.Collections.Generic;
using System.Linq;

namespace SyncfusionSchedulerDeleteBug.DataAccess.Mock.Workers
{
    public class WorkersDal : IWorkersDal
    {
        //static to check update works
        private static readonly List<WorkerInfoData> workersTable;

        static WorkersDal()
        {
            workersTable = new List<WorkerInfoData>()
            {
                new WorkerInfoData()
                {
                    Id = 1,
                    TypeId = 1,
                    FirstName = "Richard",
                    LastName = "Mead"
                },
                new WorkerInfoData()
                {
                    Id = 2,
                    TypeId = 1,
                    FirstName = "David",
                    LastName = "Dunne"
                },
                new WorkerInfoData()
                {
                    Id = 3,
                    TypeId = 1,
                    FirstName = "Harry",
                    LastName = "Williamson"
                }
            };
        }

        public List<WorkerInfoDto> GetActiveWorkers()
        {
            var workers = (from w in workersTable
                           select new WorkerInfoDto()
                           {
                               Id = w.Id,
                               FirstName = w.FirstName,
                               LastName = w.LastName
                           }).ToList();

            return workers;
        }

        public List<WorkerInfoDto> GetUsedWorkers()
        {
            var workers = (from w in workersTable
                           select new WorkerInfoDto()
                           {
                               Id = w.Id,
                               FirstName = w.FirstName,
                               LastName = w.LastName
                           }).ToList();

            return workers;
        }

        public bool WorkerNameExists(string first, string last, int omitworkerid)
        {
            var worker = (from w in workersTable
                          where w.FirstName == first && w.LastName == last && w.Id != omitworkerid
                          select w).FirstOrDefault();

            return !(worker is null); //if worker is null, name does not exist
        }

        public bool WorkerEmailExists(string email, int omitworkerid)
        {
            throw new NotImplementedException();
        }
    }
}
