﻿using Ical.Net;
using Ical.Net.DataTypes;
using SyncfusionSchedulerDeleteBug.DataAccess.Events;
using System;
using System.Collections.Generic;
using System.Linq;

namespace SyncfusionSchedulerDeleteBug.DataAccess.Mock.Events
{
    public class EventsDal : IEventsDal
    {
        private readonly List<CalendarEventData> eventTable;
        private readonly List<CalendarEventCategoryData> categoryTable;
        private readonly List<WorkerInfoData> workersTable;

        public EventsDal()
        {
            this.eventTable = new List<CalendarEventData>()
            {
                new CalendarEventData()
                {
                    Id = 1,
                    WorkerId = 1,
                    CategoryId = (int)CategoryType.OnSite,
                    Summary = "Working M,T,W,T,F,S",
                    ProjectId = 1,
                    Location = "Finland",
                    DStart = DateTime.Now.AddHours(-24),
                    DEnd = DateTime.Now.AddHours(-23),
                    IsAllDay =true,
                    IsRecurring = true,
                    RecurrenceRule = new RecurrencePattern(FrequencyType.Weekly, 1)
                    {
                        ByDay = new List<WeekDay>()
                        {
                            new WeekDay(DayOfWeek.Monday),
                            new WeekDay(DayOfWeek.Tuesday),
                            new WeekDay(DayOfWeek.Wednesday),
                            new WeekDay(DayOfWeek.Thursday),
                            new WeekDay(DayOfWeek.Friday),
                            new WeekDay(DayOfWeek.Saturday),
                        },
                        Until = DateTimeOffset.Parse("2021-02-28").UtcDateTime
                    }.ToString()
                },
                new CalendarEventData()
                {
                    Id = 2,
                    WorkerId = 1,
                    CategoryId =(int)CategoryType.Travel,
                    Summary = "Travel out 31/1",
                    ProjectId = 1,
                    Location = "Finland",
                    DStart = DateTime.Now.AddHours(12),
                    DEnd = DateTime.Now.AddHours(13),
                    IsAllDay = false
                },
                new CalendarEventData()
                {
                    Id = 3,
                    WorkerId = 1,
                    CategoryId =(int)CategoryType.Travel,
                    Summary = "Travel return 03/01",
                    ProjectId = 1,
                    Location = "Finland",
                    DStart = DateTime.Now.AddHours(16),
                    DEnd = DateTime.Now.AddHours(17),
                    IsAllDay =true
                },
                new CalendarEventData()
                {
                    Id = 4,
                    WorkerId = 2,
                    CategoryId = (int)CategoryType.OnSite,
                    Summary = "OnSite M,T",
                    ProjectId = 2,
                    Location = "Netherlands",
                    DStart = DateTime.Now.AddHours(16),
                    DEnd = DateTime.Now.AddHours(17),
                    IsAllDay =true,
                    IsRecurring = true,
                    RecurrenceRule = new RecurrencePattern(FrequencyType.Weekly, 1)
                    {
                        ByDay = new List<WeekDay>()
                        {
                            new WeekDay(DayOfWeek.Monday),
                            new WeekDay(DayOfWeek.Tuesday),
                        }
                    }.ToString()
                },
                new CalendarEventData()
                {
                    Id = 7,
                    WorkerId = 2,
                    CategoryId = (int)CategoryType.Rotation,
                    Summary = "Roation 17/02 - 20/02",
                    ProjectId = 2,
                    Location = "Netherlands",
                    DStart = DateTime.Now.AddHours(16),
                    DEnd = DateTime.Now.AddHours(17),
                    IsAllDay =true,
                   IsRecurring = false
                },
                new CalendarEventData()
                {
                    Id = 7,
                    WorkerId = 2,
                    CategoryId = (int)CategoryType.Other,
                    Summary = "UCT TEST -9 HOURS 4pm to 2am to 28th",
                    ProjectId = 2,
                    Location = "Netherlands",
                    DStart = DateTime.Now.AddHours(-16),
                    DEnd = DateTime.Now.AddHours(-17),
                    IsAllDay =false
                },
                new CalendarEventData()
                {
                    Id = 5,
                    WorkerId = 3,
                    CategoryId = (int)CategoryType.Travel,
                    Summary = "Travel out 02/01",
                    ProjectId = 2,
                    Location = "Spain",
                    DStart = DateTime.Now.AddHours(18),
                    DEnd = DateTime.Now.AddHours(19),
                    IsAllDay =true
                },
                new CalendarEventData()
                {
                    Id = 6,
                    WorkerId = 3,
                    CategoryId = (int)CategoryType.C19_Test,
                    Summary = "C19 Test 02/02 02/05" ,
                    ProjectId = 2,
                    Location = "Spain",
                    DStart = DateTime.Now.AddHours(20),
                    DEnd = DateTime.Now.AddHours(22),
                    IsAllDay =true,
                    IsRecurring = true,
                    RecurrenceRule = new RecurrencePattern(FrequencyType.Daily, 1) { Count = 3 }.ToString()
                },
                new CalendarEventData()
                {
                    Id = 7,
                    WorkerId = 3,
                    CategoryId = (int)CategoryType.Holiday,
                    Summary = "holiday 02/06" ,
                    ProjectId = 2,
                    Location = "Spain",
                    DStart = DateTime.Now.AddHours(-16),
                    DEnd = DateTime.Now.AddHours(-17),
                    IsAllDay =true,
                    IsRecurring = false
                },
                new CalendarEventData()
                {
                    Id = 6,
                    WorkerId = 3,
                    CategoryId = (int)CategoryType.OnSite,
                    Summary = "On Site 02/07 M,T,W",
                    ProjectId = 2,
                    Location = "Spain",
                    DStart = DateTime.Parse("2021-02-07T07:00"),
                    DEnd = DateTime.Parse("2021-02-07T17:00"),
                    IsAllDay =true,
                    IsRecurring = true,
                    RecurrenceRule = new RecurrencePattern(FrequencyType.Weekly, 1)
                    {
                        ByDay = new List<WeekDay>()
                        {
                            new WeekDay(DayOfWeek.Monday),
                            new WeekDay(DayOfWeek.Tuesday),
                            new WeekDay(DayOfWeek.Wednesday)
                        },
                        Until = DateTimeOffset.Parse("2021-02-16").UtcDateTime
                    }.ToString()
                },
                new CalendarEventData()
                {
                    Id = 7,
                    WorkerId = 3,
                    CategoryId = (int)CategoryType.Rotation,
                    Summary = "Roation 17/02 - 20/02",
                    ProjectId = 2,
                    Location = "Spain",
                    DStart = DateTime.Parse("2021-02-17T07:00"),
                    DEnd = DateTime.Parse("2021-02-17T17:00"),
                    IsAllDay =true,
                    IsRecurring = true,
                    RecurrenceRule = new RecurrencePattern(FrequencyType.Daily, 1) { Count = 3 }.ToString()
                },
                new CalendarEventData()
                {
                    Id = 7,
                    WorkerId = 3,
                    CategoryId = (int)CategoryType.Holiday,
                    Summary = "2020 01/03" ,
                    ProjectId = 2,
                    Location = "Spain",
                    DStart = DateTime.Parse("2022-03-01T07:00"),
                    DEnd = DateTime.Parse("2022-03-01T17:00"),
                    IsAllDay =true,
                    IsRecurring = false
                }
            };

            this.categoryTable = new List<CalendarEventCategoryData>()
            {
                new CalendarEventCategoryData()
                {
                    Id = 1,
                    Description = "Travel",
                    DisplayAs = "T",
                    BackgroundColour = "#337AFF"
                },
                new CalendarEventCategoryData()
                {
                    Id = 2,
                    Description = "On Site",
                    DisplayAs = "S",
                    BackgroundColour = "#07B81A"
                },
                new CalendarEventCategoryData()
                {
                    Id = 3,
                    Description = "Rotation",
                    DisplayAs = "R",
                    BackgroundColour = "#FFFFFF",
                    ForegroundColour = "#000000"
                },
                new CalendarEventCategoryData()
                {
                    Id = 4,
                    Description = "Holiday",
                    DisplayAs = "H",
                    BackgroundColour = "#FEFB3B"
                }
                ,
                new CalendarEventCategoryData()
                {
                    Id = 5,
                    Description = "C19 Test",
                    DisplayAs = "C19",
                    BackgroundColour = "#FF3333"
                }
                ,
                new CalendarEventCategoryData()
                {
                    Id = 6,
                    Description = "Meeting",
                    DisplayAs = "M",
                    BackgroundColour = "#3BE9FE"
                }
                ,
                new CalendarEventCategoryData()
                {
                    Id = 7,
                    Description = "Other",
                    DisplayAs = "O",
                    BackgroundColour = "#FE3BBA"
                }
            };

            this.workersTable = new List<WorkerInfoData>()
            {
                new WorkerInfoData()
                {
                    Id = 1,
                    TypeId = 1,
                    FirstName = "Richard",
                    LastName = "Mead"
                },
                new WorkerInfoData()
                {
                    Id = 2,
                    TypeId = 1,
                    FirstName = "David",
                    LastName = "Dunne"
                },
                new WorkerInfoData()
                {
                    Id = 3,
                    TypeId = 1,
                    FirstName = "Harry",
                    LastName = "Williamson"
                }
            };
        }

        public void Delete(int Id)
        {
            //throw new NotImplementedException();
        }

        public CalendarEventEditDto Fetch(int Id)
        {
            return new CalendarEventEditDto();

            //throw new NotImplementedException();
        }

        public CalendarEventInfoDto GetCalendarEvent(int Id)
        {
            var query = (from e in this.eventTable
                         join c in this.categoryTable on e.CategoryId equals c.Id
                         join w in this.workersTable on e.WorkerId equals w.Id
                         where e.Id == Id
                         select new CalendarEventInfoDto
                         {
                             Id = e.Id,
                             WorkerId = e.WorkerId,
                             WorkersFullName = w.FullName,
                             Title = c.DisplayAs,
                             Summary = e.Summary,
                             ProjectId = e.ProjectId,
                             Location = e.Location,
                             DStart = e.DStart,
                             DEnd = e.DEnd,
                             IsAllDay = e.IsAllDay,
                             RecurrenceRule = e.RecurrenceRule,
                             BackgroundColor = c.BackgroundColour,
                             ForegroundColor = c.ForegroundColour
                         }).FirstOrDefault();

            return query;
        }

        public List<CalendarEventInfoDto> GetCalendarEvents(DateTime startdate, DateTime enddate)
        {
            var query = (from e in this.eventTable
                         join c in this.categoryTable on e.CategoryId equals c.Id
                         join w in this.workersTable on e.WorkerId equals w.Id
                         where e.DStart >= startdate && e.DEnd <= enddate
                         select new CalendarEventInfoDto
                         {
                             Id = e.Id,
                             WorkerId = e.WorkerId,
                             WorkersFullName = w.FullName,
                             Title = c.DisplayAs,
                             Summary = e.Summary,
                             ProjectId = e.ProjectId,
                             Location = e.Location,
                             DStart = e.DStart,
                             DEnd = e.DEnd,
                             IsAllDay = e.IsAllDay,
                             RecurrenceRule = e.RecurrenceRule,
                             BackgroundColor = c.BackgroundColour,
                             ForegroundColor = c.ForegroundColour
                         }).ToList();

            return query;
        }

        public List<EventCategoryDto> GetCategories()
        {
            throw new NotImplementedException();
        }

        public void Insert(CalendarEventEditDto data)
        {
            //throw new NotImplementedException();
        }

        public void Update(CalendarEventEditDto data)
        {
            //throw new NotImplementedException();
        }
    }
}
