﻿using System;
using System.Collections.Generic;
using System.Text;
using Csla;
using SyncfusionSchedulerDeleteBug.DataAccess.Workers;

namespace SyncfusionSchedulerDeleteBug.Business.Workers
{
    [Serializable]
    public class WorkerInfo : ReadOnlyBase<WorkerInfo>
    {
        #region properties

        public readonly static PropertyInfo<int> IdProperty = RegisterProperty<int>(nameof(Id));
        public int Id
        {
            get { return GetProperty(IdProperty); }
            set { LoadProperty(IdProperty, value); }
        }

        public readonly static PropertyInfo<string> FirstNameProperty = RegisterProperty<string>(nameof(FirstName));
        public string FirstName
        {
            get { return GetProperty(FirstNameProperty); }
            set { LoadProperty(FirstNameProperty, value); }
        }

        public readonly static PropertyInfo<string> LastNameProperty = RegisterProperty<string>(nameof(LastName));
        public string LastName
        {
            get { return GetProperty(LastNameProperty); }
            set { LoadProperty(LastNameProperty, value); }
        }

        public string WorkersFullName
        {
            get { return $"{FirstName} {LastName}"; }
        }

        public readonly static PropertyInfo<string> ReferenceProperty = RegisterProperty<string>(nameof(Reference));
        public string Reference
        {
            get { return GetProperty(ReferenceProperty); }
            set { LoadProperty(ReferenceProperty, value); }
        }

        public readonly static PropertyInfo<string> EmailProperty = RegisterProperty<string>(nameof(Email));
        public string Email
        {
            get { return GetProperty(EmailProperty); }
            set { LoadProperty(EmailProperty, value); }
        }

        public readonly static PropertyInfo<string> WorkerTypeProperty = RegisterProperty<string>(nameof(WorkerType));
        public string WorkerType
        {
            get { return GetProperty(WorkerTypeProperty); }
            set { LoadProperty(WorkerTypeProperty, value); }
        }

        public readonly static PropertyInfo<string> DefaultTimezoneIdProperty = RegisterProperty<string>(nameof(DefaultTimezoneId));
        public string DefaultTimezoneId
        {
            get { return GetProperty(DefaultTimezoneIdProperty); }
            set { LoadProperty(DefaultTimezoneIdProperty, value); }
        }

        #endregion

        #region data access

        [FetchChild]
        private void FetchChild(WorkerInfoDto workerDto)
        {
            if (workerDto is null)
                return;

            Id = workerDto.Id;
            FirstName = workerDto.FirstName;
            LastName = workerDto.LastName;
            Reference = workerDto.Reference;
            Email = workerDto.Email;
            WorkerType = workerDto.WorkerType;
            DefaultTimezoneId = workerDto.DefaultTimezoneId;
        }

        #endregion
    }
}
