﻿using Csla;
using SyncfusionSchedulerDeleteBug.DataAccess.Workers;
using System;
using System.Linq;

namespace SyncfusionSchedulerDeleteBug.Business.Workers
{
    [Serializable]
    public class UsedWorkersList : ReadOnlyListBase<UsedWorkersList, ActiveWorkerInfo>
    {
        #region data access

        [Fetch]
        private void Fetch([Inject] IWorkersDal dal)
        {
            var rlce = RaiseListChangedEvents;
            RaiseListChangedEvents = false;
            IsReadOnly = false;

            var result = dal.GetUsedWorkers();

            var ordered = result.OrderBy(x => $"{x.FirstName} {x.LastName}");

            foreach (var e in ordered)
            {
                Add(DataPortal.FetchChild<ActiveWorkerInfo>(e));
            }

            rlce = RaiseListChangedEvents;
            IsReadOnly = true;
        }

        #endregion
    }
}

