﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SyncfusionSchedulerDeleteBug.Business.Events
{
    public class UtcDateRangeDescriptionBuilder
    {
        #region properties

        public string DateFormat { get; set; }
        public string TimeFormat { get; set; }

        private string DateSpacer => string.IsNullOrEmpty(DateFormat) ? string.Empty : " ";
        private string TimeSpacer => string.IsNullOrEmpty(TimeFormat) ? string.Empty : " - ";

        #endregion

        #region constructors

        public UtcDateRangeDescriptionBuilder()
        {
            DateFormat = "MMMM dd, yyyy";
            TimeFormat = "(HH:mm)";
        }

        public UtcDateRangeDescriptionBuilder(string dateformat, string timeformat)
        {
            DateFormat = dateformat;
            TimeFormat = timeformat;
        }

        #endregion

        #region methods

        public string Build(IHoldUtcDateInfo data)
        {
            DateTime start = data.StartTime;
            DateTime end = data.EndTime;

            return Build(start, end);
        }

        public string BuildRecurrenceDescription(IHoldUtcDateInfo data)
        {
            DateTime start = data.StartTime;
            DateTime end = data.LastOccurenceDate;

            return Build(start, end);
        }

        private string Build(DateTime start, DateTime end)
        {
            if (DateAndTimeMatch(start, end))
            {
                return $"{Date(start)}{DateSpacer}{Time(start)}";
            }
            else if (DatesMatch(start, end))
            {
                var s = $"{Date(start)}{DateSpacer}{Time(start)}{TimeSpacer}{Time(end)}";
                return $"{Date(start)}{DateSpacer}{Time(start)}{TimeSpacer}{Time(end)}";
            }
            else
            {
                return $"{Date(start)}{DateSpacer}{Time(start)}{TimeSpacer}{Date(end)}{DateSpacer}{Time(end)}";
            }
        }

        private bool DateAndTimeMatch(DateTime from, DateTime to)
        {
            return from.Equals(to);
        }

        private bool DatesMatch(DateTime from, DateTime to)
        {
            return from.Date.Equals(to.Date);
        }

        private string Date(DateTime date)
        {
            if (string.IsNullOrEmpty(DateFormat))
                return string.Empty;

            return date.ToString(DateFormat);
        }

        private string Time(DateTime date)
        {
            if (string.IsNullOrEmpty(TimeFormat))
                return string.Empty;

            return date.ToString(TimeFormat);
        }

        #endregion
    }
}
