﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SyncfusionSchedulerDeleteBug.Business.Events
{
    public class TimezoneDateRangeDescriptionBuilder
    {
        #region properties

        public string DateFormat { get; set; }
        public string TimeFormat { get; set; }

        #endregion

        #region constructors

        public TimezoneDateRangeDescriptionBuilder()
        {
            DateFormat = "MMMM dd, yyyy";
            TimeFormat = "(HH:mm)";
        }

        public TimezoneDateRangeDescriptionBuilder(string dateformat, string timeformat)
        {
            DateFormat = dateformat;
            TimeFormat = timeformat;
        }

        #endregion

        #region methods

        public string Build(IHoldTimezoneDateInfo data)
        {
            DateTime start = data.TimezoneStartTime;
            TimeSpan startTz = data.StartTimeOffset;

            DateTime end = data.TimezoneEndTime;
            TimeSpan endTz = data.EndTimeOffset;

            if (DateAndTimeMatch(start, end))
            {
                return $"{Date(start)} {Time(start)} {Timezone(startTz)}";
            }
            else if (DatesMatch(start, end))
            {
                if (TimezonesMatch(startTz, endTz))
                {
                    return $"{Date(start)} {Time(start)} - {Time(end)} {Timezone(startTz)}";
                }
                else
                {
                    return $"{Date(start)} {Time(start)} {Timezone(startTz)} - {Time(end)} {Timezone(endTz)}";
                }
            }
            else
            {
                return $"{Date(start)} {Time(start)} {Timezone(startTz)} - {Date(end)} {Time(end)} {Timezone(endTz)}";
            }
        }
        public string BuildDatesOnly(IHoldTimezoneDateInfo data)
        {
            DateTime start = data.TimezoneStartTime;
            DateTime end = data.TimezoneEndTime;

            if (DateAndTimeMatch(start, end) || DatesMatch(start, end))
            {
                return Date(start);
            }
            else
            {
                return $"{Date(start)} - {Date(end)}";
            }
        }

        private bool DateAndTimeMatch(DateTime from, DateTime to)
        {
            return from.Equals(to);
        }

        private bool DatesMatch(DateTime from, DateTime to)
        {
            return from.Date.Equals(to.Date);
        }

        private bool TimezonesMatch(TimeSpan start, TimeSpan end)
        {
            return start.Equals(end);
        }

        private string Date(DateTime date)
        {
            if (string.IsNullOrEmpty(DateFormat))
                return string.Empty;

            return date.ToString(DateFormat);
        }

        private string Time(DateTime date)
        {
            if (string.IsNullOrEmpty(TimeFormat))
                return string.Empty;

            return date.ToString(TimeFormat);
        }

        private string Timezone(TimeSpan offset)
        {
            return offset.ToUtcString();
        }

        #endregion
    }
}
