﻿using System;
using System.Collections.Generic;
using System.Text;
using Csla;
using SyncfusionSchedulerDeleteBug.DataAccess.Events;

namespace SyncfusionSchedulerDeleteBug.Business.Events
{
    [Serializable]
    public class EventCategoryInfo: ReadOnlyBase<EventCategoryInfo>
    {
        #region properties

        public readonly static PropertyInfo<int> IdProperty = RegisterProperty<int>(nameof(Id));
        public int Id
        {
            get { return GetProperty(IdProperty); }
            set { LoadProperty(IdProperty, value); }
        }
       
        public readonly static PropertyInfo<string> DescriptionProperty = RegisterProperty<string>(nameof(Description));
        public string Description
        {
            get { return GetProperty(DescriptionProperty); }
            set { LoadProperty(DescriptionProperty, value); }
        }

        public readonly static PropertyInfo<string> DisplayAsProperty = RegisterProperty<string>(nameof(DisplayAs));
        public string DisplayAs
        {
            get { return GetProperty(DisplayAsProperty); }
            set { LoadProperty(DisplayAsProperty, value); }
        }

        public readonly static PropertyInfo<string> BackgroundColorProperty = RegisterProperty<string>(nameof(BackgroundColor));
        public string BackgroundColor
        {
            get { return GetProperty(BackgroundColorProperty); }
            set { LoadProperty(BackgroundColorProperty, value); }
        }

        public readonly static PropertyInfo<string> ForegroundColorProperty = RegisterProperty<string>(nameof(ForegroundColor));
        public string ForegroundColor
        {
            get { return GetProperty(ForegroundColorProperty); }
            set { LoadProperty(ForegroundColorProperty, value); }
        }

        #endregion

        #region data access

        [FetchChild]
        private void Fetch(EventCategoryDto dto)
        {
            if (dto is null)
                return;

            Id = dto.Id;
            Description = dto.Description;
            DisplayAs = dto.DisplayAs;
            BackgroundColor = dto.BackgroundColor;
            ForegroundColor = dto.ForegroundColor;
        }

            #endregion
    }
}
