﻿using Csla;
using SyncfusionSchedulerDeleteBug.DataAccess.Events;
using System;
using System.Linq;

namespace SyncfusionSchedulerDeleteBug.Business.Events
{
    [Serializable]
    public class EventCategoriesList: ReadOnlyListBase<EventCategoriesList, EventCategoryInfo>
    {
        [Fetch]
        private void Fetch([Inject] IEventsCategoryDal dal)
        {
            var rlce = RaiseListChangedEvents;
            RaiseListChangedEvents = false;
            IsReadOnly = false;

            var result = dal.GetCategories();

            var ordered = result.OrderBy(x => x.Description);

            foreach (var e in ordered)
            {
                Add(DataPortal.FetchChild<EventCategoryInfo>(e));
            }

            rlce = RaiseListChangedEvents;
            IsReadOnly = true;
        }
    }
}
