﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SyncfusionSchedulerDeleteBug.Business.Events
{
    //move to leito.core?
    public static class DateTimeOffsetExtensions
    {
        public static DateTimeOffset ApplyOffsetByTimezoneId(this DateTime date, string timezoneid)
        {
            TimeZoneInfo tz = TimeZoneInfo.FindSystemTimeZoneById(timezoneid);

            return ApplyOffset(date, tz.BaseUtcOffset);
        }

        public static DateTimeOffset ApplyOffset(this DateTime date, TimeSpan offset)
        {
            var unspecifiedDate = DateTime.SpecifyKind(date, DateTimeKind.Unspecified);

            return new DateTimeOffset(unspecifiedDate, offset);
        }
    }
}
