using Csla.Configuration;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Logging;
using SyncfusionSchedulerDeleteBug.Blazor.Server.Shared;
using Syncfusion.Blazor;
using SyncfusionSchedulerDeleteBug.DataAccess.Mock;

namespace SyncfusionSchedulerDeleteBug.Blazor.Server
{
    public class Startup
    {
        public Startup(IConfiguration configuration)
        {
            SyncfusionLicenseActivator.Activate();

            Configuration = configuration;
        }

        public IConfiguration Configuration { get; }

        // This method gets called by the runtime. Use this method to add services to the container.
        // For more information on how to configure your application, visit https://go.microsoft.com/fwlink/?LinkID=398940
        public void ConfigureServices(IServiceCollection services)
        {
            services.AddRazorPages();
            services.AddServerSideBlazor();

            services.AddSyncfusionBlazor();
            services.AddCsla().WithBlazorServerSupport();

            services.AddScoped<TimeZoneService>();
            services.AddScoped<ScheduleController>();

            services.AddDataAccessMock();
        }

        // This method gets called by the runtime. Use this method to configure the HTTP request pipeline.
        public void Configure(IApplicationBuilder app, IWebHostEnvironment env, ILoggerFactory logger)
        {
            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }
            else
            {
                app.UseExceptionHandler("/Error");                
                app.UseHsts();
            }

            app.UseHttpsRedirection();
            app.UseStaticFiles();

            app.UseRouting();         

            app.UseEndpoints(endpoints =>
            {
                endpoints.MapControllers();
                endpoints.MapBlazorHub();
                endpoints.MapFallbackToPage("/_Host");
            });

            app.UseCsla();
        }
    }
}
