﻿using Microsoft.Extensions.Configuration;
using PTCalendar.DataAccess;
using System.Collections.Generic;

namespace PTCalendar.Blazor.Server
{
    public class DbConnectionFactory: IDbConnectionFactory
    {
        private readonly Dictionary<string, string> connections;

        public DbConnectionFactory(IConfiguration configuration)
        {
            connections = new Dictionary<string, string>();

            IConfigurationSection section = configuration.GetSection("ConnectionStrings");

            foreach (var s in section.GetChildren())
            {
                connections.Add(s.Key, configuration.GetConnectionString(s.Key));
            }
        }

        public string GetConnectionString(string key)
        {
            return string.IsNullOrEmpty(key) ? string.Empty : connections[key];
        }
    }
}
