﻿using SyncfusionSchedulerDeleteBug.Business.Events;
using Syncfusion.Blazor.Schedule;
using Csla;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.Extensions.Logging;

namespace SyncfusionSchedulerDeleteBug.Blazor.Server
{
    public class ScheduleController
    {
        private readonly ILogger<ScheduleController> logger;

        public ScheduleController(ILogger<ScheduleController> logger)
        {
            this.logger = logger;
        }

        public void EventChange(ActionEventArgs<CalendarEventInfo> args)
        {
            if (args == null) return;

            try
            {
                foreach (var item in args.ChangedRecords)
                {
                    if (item.IsRecurring)
                    {
                        //todo determine when this happens
                        //drag drop ? YES but no question about series or individual
                        //delete ? NO that comes into remove event
                        //edit
                        //CalendarEventEdit edit = DataPortal.Fetch<CalendarEventEdit>(item.Id);
                        //edit.RecurrenceException = item.RecurrenceException;
                        //_ = edit.Save();
                    }
                    else
                    {
                        CalendarEventEdit edit = DataPortal.Fetch<CalendarEventEdit>(item.Id);
                        edit.DStart = item.StartTime;
                        edit.DEnd = item.EndTime;
                        _ = edit.Save();
                    }
                }
            }
            catch (Exception ex)
            {
                logger.LogError(ex, "Unable to change event due to an error");
                throw;
            }           
        }

        public void EventDelete(List<CalendarEventInfo> deletedrecords, List<CalendarEventInfo> changedrecords)
        {
            //todo if deleteing a single event from a series does come to here but with changed records
            //and recurrence exception is set
            //if delete a series also comes here but deleted records is set as expected
            try
            {
                if (deletedrecords != null)
                {
                    foreach (var item in deletedrecords)
                    {
                        DataPortal.Delete<CalendarEventEdit>(item.Id);
                    }
                }
            }
            catch (Exception ex)
            {
                logger.LogError(ex, "Unable to delete events due to an error");
                throw;
            }

            try
            {
                if (changedrecords != null)
                {
                    foreach (var item in changedrecords)
                    {
                        CalendarEventEdit edit = DataPortal.Fetch<CalendarEventEdit>(item.Id);
                        edit.AddOccurenceException(item.RecurrenceException);
                        _ = edit.Save();

                        item.RecurrenceException = edit.RecurrenceException; //set the occurence exception from the grid to the appended one
                    }
                }
            }
            catch (Exception ex)
            {
                logger.LogError(ex, "Unable to 'delete' occurence events due to an error");
                throw;
            }
        }
    }
}
