import { Internationalization } from '@syncfusion/ej2-base';

/** Tools */
export class Tools {
  private static _dateFormat: string;
  private static _timeFormat: string;
  private static _dateTimeFormat: string;

  public static readonly maxDate: Date = new Date(9999, 11, 31, 23, 59, 0);
  public static readonly minDate: Date = new Date(1753, 0, 1, 0, 0, 0);

  /** Resolve date format. */
  public static getDateFormat(): string {
    return this._dateFormat || (this._dateFormat = new Internationalization().getDatePattern({ type: "date", skeleton: "yMd" }));
  }
  /** Resolve time format. */
  public static getTimeFormat(): string {
    return this._timeFormat || (this._timeFormat = new Internationalization().getDatePattern({ type: "time", skeleton: "Hms" }));
  }
  /** Resolve date time format. */
  public static getDateTimeFormat(): string {
    return this._dateTimeFormat || (this._dateTimeFormat = this.getDateFormat() + " " + this.getTimeFormat());
  }

  /**
   * Check if value is null or undefined.
   * @param value
   */
  public static isNullOrUndefined(value: any): boolean {
    return value === null || value === undefined;
  }
}
