import { Component, OnInit, ViewChild } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { DateTimePicker } from '@syncfusion/ej2-angular-calendars';
import { Column, EditSettingsModel, GridComponent, IEditCell, ToolbarItem, EditService, ToolbarService } from '@syncfusion/ej2-angular-grids';
import { Tools } from '../models/tools';
import { DataManager } from '@syncfusion/ej2-data';
import { DropDownListModel } from '@syncfusion/ej2-angular-dropdowns';
import { Query } from "@syncfusion/ej2-data"

@Component({
  selector: 'grid-batch-drop-down-demo',
  templateUrl: './grid-batch-drop-down-demo.component.html',
  styleUrls: ['./grid-batch-drop-down-demo.component.scss'],
  providers: [
    ToolbarService,
    EditService
  ]
})
export class GridBatchDropDownDemoComponent implements OnInit {

  @ViewChild("demoGrid")
  public grid: GridComponent;
  public columns: Column[] = [];
  private _dataSource: any[] = [
    {
      id: 1,
      value: "Value 1",
      comboValue: "1"
    },
    {
      id: 2,
      value: "Value 2",
      comboValue: "2"
    }
  ]
  private dateTimeElement: HTMLElement;
  private dateTimePickerObject: DateTimePicker;
  public dataSource: any;
  public editSettings: EditSettingsModel = {
    allowEditing: true,
    allowEditOnDblClick: true,
    mode: "Batch"
  };
  public toolbar: (ToolbarItem)[] = [ToolbarItem.Edit, ToolbarItem.Update, ToolbarItem.Cancel];

  constructor() { }

  ngOnInit(): void {
    var columns: Column[] = [];
    // prepare columns
    columns.push(new Column({
      field: "id",
      isPrimaryKey: true,
      allowEditing: false
    }));
    columns.push(new Column({
      field: "value",
      headerText: "Value"
    }));

    var dateColumn = new Column({
      field: "comboValue",
      type: "String",
      textAlign: "Left",
      allowEditing: true,
      headerText: "Combo value",
      editType: "dropdownedit"
    });
    var dropDownModel: DropDownListModel = {
      allowFiltering: true,
      dataSource: ["1", "2", "3", "4", "5"],
      fields: { text: "comboValue", value: "comboValue" },
      popupWidth: "auto",
      query: new Query(),
    };
    var editParams: IEditCell = {
      params: dropDownModel
    };
    dateColumn.edit = editParams;
    columns.push(dateColumn);
    this.columns = columns;
    this.dataSource = new DataManager({
      json: this._dataSource
    });
  }
}
