import { BrowserModule } from '@angular/platform-browser';
import { NgModule } from '@angular/core';
import { FormsModule } from '@angular/forms';
import { HttpClientModule } from '@angular/common/http';
import { RouterModule } from '@angular/router';
import { GridModule } from '@syncfusion/ej2-angular-grids';
import { DateTimePickerModule } from '@syncfusion/ej2-angular-calendars';

import { AppComponent } from './app.component';
import { NavMenuComponent } from './nav-menu/nav-menu.component';
import { GridBatchDropDownDemoComponent } from './grid-batch-drop-down-demo/grid-batch-drop-down-demo.component';

@NgModule({
  declarations: [
    AppComponent,
    NavMenuComponent,
    GridBatchDropDownDemoComponent
  ],
  imports: [
    BrowserModule.withServerTransition({ appId: 'ng-cli-universal' }),
    HttpClientModule,
    FormsModule,
    RouterModule.forRoot([
      { path: '', pathMatch: 'full', redirectTo: 'grid-batch-drop-down-demo' },
      { path: 'grid-batch-drop-down-demo', component: GridBatchDropDownDemoComponent }
], { relativeLinkResolution: 'legacy' }),
    GridModule,
    DateTimePickerModule
  ],
  providers: [
  ],
  bootstrap: [AppComponent],
  exports: []
})
export class AppModule { }
