﻿using Syncfusion.Pdf;
using Syncfusion.Pdf.Graphics;
using Syncfusion.Pdf.Interactive;
using Syncfusion.Pdf.Parsing;
using Syncfusion.Windows.PdfViewer;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace test1
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        string m_szPath = "";
        public MainWindow()
        {
          
            InitializeComponent();
            Loaded += MainWindow_Loaded;
        }

        private void MainWindow_Loaded(object sender, RoutedEventArgs e)
        {
            //
            m_szPath = System.IO.Directory.GetCurrentDirectory();

            string demofile = m_szPath + @"\p2.pdf";
            myPdfViewer.Load(demofile);
            myPdfViewer.ZoomMode = ZoomMode.FitPage;
           
        }

        private void Button_Click(object sender, RoutedEventArgs e)
        {
            string target = m_szPath + @"\33.pdf";
            myPdfViewer.Save(target);

            MessageBox.Show("save to :"+target);
        }

        private void Button2_Click(object sender, RoutedEventArgs e)
        {
            string demofile = m_szPath + @"\p2.pdf";
            PdfLoadedDocument loadedDocumentTarget = myPdfViewer.LoadedDocument;
            int iPage = 0;

            PdfColor pdfColor = new PdfColor(System.Drawing.Color.Black);

            foreach (PdfPageBase pageTarget in loadedDocumentTarget.Pages)
            {
                myPdfViewer.GotoPage(iPage + 1);
                loadedDocumentTarget = myPdfViewer.LoadedDocument;
                PdfLoadedAnnotationCollection annotationsTarget = loadedDocumentTarget.Pages[iPage].Annotations;
                iPage++;
                if (annotationsTarget.Count != 0)
                {
                    foreach (dynamic annFree in annotationsTarget)
                    {
                        if (annFree is PdfFreeTextAnnotation || annFree is PdfLoadedFreeTextAnnotation)
                        {
                            annFree.TextMarkupColor = pdfColor;
                        }
                    }
                }

            }
            string target = m_szPath + @"\44.pdf";
            myPdfViewer.Save(target);

            MessageBox.Show("save to :" + target);
        }
    }
}
