﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;

namespace TestDocking
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        private void MainWin_Loaded(object sender, RoutedEventArgs e)
        {
            string DockStateFile = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments), "DockState.xml");
            if(File.Exists(DockStateFile)) {
                DockMgr.LoadDockState(new BinaryFormatter(), Syncfusion.Windows.Shared.StorageFormat.Xml, DockStateFile);
            }
        }

        private void MainWin_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            string DockStateFile = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments), "DockState.xml");
            DockMgr.SaveDockState(new BinaryFormatter(), Syncfusion.Windows.Shared.StorageFormat.Xml, DockStateFile);
        }
    }
}
