﻿using System.IO;
using Syncfusion.XlsIO;

namespace DocGenRepro {
    class Program {
        private const string FileExt = "xlsx";
        private const string FileName = "FormattedAndComplex";

        static void Main(string[] args) {
            var dir = Directory.GetParent(Directory.GetCurrentDirectory()).Parent?.FullName;
            var filePath = $"{dir}\\{FileName}";
            var excelApp = new ExcelEngine().Excel;

            //MemoryStream Example
            using (var stream = new MemoryStream()) {
                byte[] fileBytes = File.ReadAllBytes($"{ filePath}.{ FileExt}");
                stream.Write(fileBytes, 0, fileBytes.Length);

                excelApp.DefaultVersion = ExcelVersion.Excel2007;
                var excel = excelApp.Workbooks.Open(stream, ExcelOpenType.SpreadsheetML2007);

                var worksheet = excel.Worksheets["(b) NG Pneumatic Devices"];

                WriteTo(excel, "(b) NG Pneumatic Devices", "S33", "2");

                excel.SaveAs($"{filePath}-memory-stream-out.{FileExt}");
            }

            //FileStream Example
            using (var inFile = new FileStream($"{filePath}.{FileExt}", FileMode.Open)) {
                var excel = excelApp.Workbooks.Open(inFile, ExcelOpenType.SpreadsheetML2007);

                var worksheet = excel.Worksheets[0];

                WriteTo(excel, "(b) NG Pneumatic Devices", "S33", "2");

                excel.SaveAs($"{filePath}-file-stream-out.{FileExt}");
            }
        }

        static void WriteTo(IWorkbook excel, string wrksheet, string cell, string value) {
            var sheet = excel.Worksheets[wrksheet];
            var c = sheet[cell];
            c.Value = value;
        }
    }
}