﻿using System;
using System.Data;
using System.IO;
using System.Linq;
using Syncfusion.XlsIO;

namespace DocGenRepro {
    class Program {
        private const string FileExt = "xlsx";
        private const string FileName = "MultipleGroupedFormControlsExample";
        private const string sheet = "Sheet1";

        static void Main(string[] args) {
            var dir = Directory.GetParent(Directory.GetCurrentDirectory()).Parent?.FullName;
            var filePath = $"{dir}\\{FileName}";
            var excelApp = new ExcelEngine().Excel;


            //Multiple Writes Example
            using (var stream = new MemoryStream()) {
                byte[] fileBytes = File.ReadAllBytes($"{ filePath}.{ FileExt}");
                stream.Write(fileBytes, 0, fileBytes.Length);

                excelApp.DefaultVersion = ExcelVersion.Excel2007;
                var excel = excelApp.Workbooks.Open(stream, ExcelOpenType.SpreadsheetML2007);

                WriteTo(excel, sheet, "E5", "2"); // Persists
                WriteTo(excel, sheet, "E6", "2"); // Does not persist
                WriteTo(excel, sheet, "E7", "2"); // Persists

                excel.SaveAs($"{filePath}-multiple-write-out.{FileExt}");
            }

            //Data Table Example
            using (var stream = new MemoryStream()) {
                byte[] fileBytes = File.ReadAllBytes($"{ filePath}.{ FileExt}");
                stream.Write(fileBytes, 0, fileBytes.Length);

                excelApp.DefaultVersion = ExcelVersion.Excel2007;
                var excel = excelApp.Workbooks.Open(stream, ExcelOpenType.SpreadsheetML2007);

                var worksheet = excel.Worksheets[0];

                var location = "'Sheet1'!D5";
                var value = "[Q1]\t2\r\n[Q2]\t2\r\n[Q3]\t2"; //First and Third "2" persist but not the Second
                var table = GetDataTableFromDelimitedString(value, '\t');
                IRange range = worksheet.Range[location.Split('!').Last().Trim()];
                worksheet.ImportDataTable(table, false, range.Row, range.Column, false);

                excel.SaveAs($"{filePath}-datatable-out.{FileExt}");
            }

            //File Stream Example
            using (var inFile = new FileStream($"{filePath}.{FileExt}", FileMode.Open)) {
                var excel = excelApp.Workbooks.Open(inFile, ExcelOpenType.SpreadsheetML2007);

                var worksheet = excel.Worksheets[0];

                var location = "'Sheet1'!D5";
                var value = "[Q1]\t2\r\n[Q2]\t2\r\n[Q3]\t2"; //First and Third "2" persist but not the Second
                var table = GetDataTableFromDelimitedString(value, '\t');
                IRange range = worksheet.Range[location.Split('!').Last().Trim()];
                worksheet.ImportDataTable(table, false, range.Row, range.Column, false);

                excel.SaveAs($"{filePath}-filestream-out.{FileExt}");
           
            }
        }

        static void WriteTo(IWorkbook excel, string wrksheet, string cell, string value) {
            var sheet = excel.Worksheets[wrksheet];
            var c = sheet[cell];
            c.Value = value;
        }

        private static DataTable GetDataTableFromDelimitedString(string delimited, char delimiter) {
            var lines = delimited.Split(new[] { "\r\n", "\n" }, StringSplitOptions.None).Where(line => !String.IsNullOrEmpty(line));
            var table = new DataTable();
            foreach (var line in lines) {
                var cells = line.Split(delimiter);
                var numColumn = table.Columns.Count;
                if (cells.Count() > numColumn) {
                    for (int i = 0; i < cells.Count() - numColumn; ++i) {
                        table.Columns.Add();
                    }
                }
                table.Rows.Add(cells.ToArray());
            }
            return table;
        }
    }
}