﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SfTreeGrid_MVVM
{
    public class EmployeeBase : IEmployeeBase
    {
       
        string _firstName;
        public string FirstName
        {
            get { return _firstName; }
            set { _firstName = value; }
        }
    }
    public class EmployeeBase1 : EmployeeBase,IEmployeeBase1
    {
        string _lastName;
        public string LastName
        {
            get { return _lastName; }
            set { _lastName = value; }
        }
    }
    public class EmployeeInfo: EmployeeBase1,IEmployeeInfo
    {
        int _id;
        
        private string _title;
        decimal _salary;
        ObservableCollection<IEmployeeBase> _children;



        [Range(1, 2, ErrorMessage = "ID between 1 and 2 alone processed")]
        public int ID
        {
            get { return _id; }
            set { _id = value; }
        }

        public string Title
        {
            get { return _title; }
            set { _title = value; }
        }

        public decimal Salary
        {
            get { return _salary; }
            set { _salary = value; }
        }

        public ObservableCollection<IEmployeeBase> Children
        {
            get
            {
                if (_children == null)
                    _children = new ObservableCollection<IEmployeeBase>();
                return _children;
            }
            set
            {
                _children = value;               
            }
        }

       
    }
}
