﻿using Syncfusion.Data;
using Syncfusion.UI.Xaml.TreeGrid;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace SfTreeGrid_MVVM
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
            treeGrid.Loaded += TreeGrid1_Loaded;
        }

        private void TreeGrid1_Loaded(object sender, RoutedEventArgs e)
        {

            var dc = treeGrid.DataContext as ViewModel;
            if(dc != null)
                this.treeGrid.SourceType = dc.SourceType;

            SortComparer sc = new SortComparer();
            sc.PropertyName = "FirstName";
            sc.Comparer = new CustomComparer();
            SortComparer sc1 = new SortComparer();
            sc1.PropertyName = "LastName";
            sc1.Comparer = new CustomComparer();
            treeGrid.SortComparers.Add(sc);
            treeGrid.SortComparers.Add(sc1);
            

        }

        private void OnTreeGrid_Loaded(object sender, RoutedEventArgs e)
        {
            this.treeGrid.View.NodeCollectionChanged += OnView_NodeCollectionChanged;
            
        }

        private void OnView_NodeCollectionChanged(object sender, System.Collections.Specialized.NotifyCollectionChangedEventArgs e)
        {
            if(e.Action == System.Collections.Specialized.NotifyCollectionChangedAction.Add)
            {
                foreach (TreeNode node in e.NewItems)
                    if (!node.IsExpanded)
                        node.IsExpanded = true;
            }
        }

      
    }

    public class CustomComparer : IComparer<object>
    {
        public CustomComparer()
        {

        }
        public int Compare(object x, object y)
        {
            var employeeX = x as EmployeeInfo;
            var employeeY = y as EmployeeInfo;
            if(employeeX != null && employeeY != null)
            {
                if(employeeX.ID == 2 && employeeY.ID ==2)
                {
                    return employeeX.FirstName.CompareTo(employeeY.FirstName);
                }
                else
                    return employeeX.LastName.CompareTo(employeeY.LastName);
            }
            return 0;
        }
    }
}
