﻿using Syncfusion.DocIO.DLS;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MergeDocs
{
    class Program
    {
        static void Main(string[] args)
        {
            using (WordDocument destinationDoc = new WordDocument("SampleDestination.docx"))
            {
                using (WordDocument sourceDoc = new WordDocument("SampleSource.docx"))
                {
                    destinationDoc.ImportContent(sourceDoc, ImportOptions.KeepSourceFormatting | ImportOptions.ListRestartNumbering);

                    // If used ImportOptions.UseDestinationStyles the content looks the same except the numbering isn't restarted
                    //destinationDoc.ImportContent(sourceDoc, ImportOptions.UseDestinationStyles | ImportOptions.ListRestartNumbering);

                    sourceDoc.Close();
                }

                destinationDoc.Save("SampleResult.docx");
                destinationDoc.Close();
            }

            Process.Start("SampleResult.docx");
        }
    }
}
