using System.Threading.Tasks;

using Microsoft.AspNetCore.Components.WebAssembly.Hosting;
using Microsoft.Extensions.DependencyInjection;

using Syncfusion.Blazor;

namespace SchedulerQueryCrash
{
    public class Program
    {
        public static async Task Main(string[] args)
        {
            var builder = WebAssemblyHostBuilder.CreateDefault(args);
            builder.RootComponents.Add<App>("#app");

            builder.Services.AddSyncfusionBlazor();

            builder.Services.AddScoped(sp => new SimpleODataAdaptor<Test>());

            await builder.Build().RunAsync();
        }
    }
}
