﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Syncfusion.XlsIO;
using Syncfusion.ExcelChartToImageConverter;
using System.IO;
using System.Drawing;

namespace Feedback26161_Console
{
    class Program
    {
        static void Main(string[] args)
        {
            using (ExcelEngine excelEngine = new ExcelEngine())
            {
                IApplication application = excelEngine.Excel;
                application.DefaultVersion = ExcelVersion.Excel2013;

                application.ChartToImageConverter = new ChartToImageConverter();
                application.ChartToImageConverter.ScalingMode = ScalingMode.Best;

                IWorkbook workbook = application.Workbooks.Open("../../Data/OriginalExcelChart.xlsx");
                IWorksheet worksheet = workbook.Worksheets[0];

                IChart chart = worksheet.Charts[0];

                //Creating the memory stream for chart image
                MemoryStream stream = new MemoryStream();

                //Saving the chart as image
                chart.SaveAsImage(stream);

                Image image = Image.FromStream(stream);

                //Saving image stream to file
                image.Save("Output.png");
                System.Diagnostics.Process.Start("Output.png");
            }
        }
    }
}
