﻿using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Linq;
using System.Threading.Tasks;
using Syncfusion.Blazor.Grids;

namespace ServerApp.Pages
{
    public partial class Index
    {
        SfGrid<ExpandoObject> dataGrid;

        public bool IsLoading { get; set; } = true;

        public List<ExpandoObject> Orders { get; set; }

        public List<FieldModel> Fields { get; set; }

        protected override async Task OnAfterRenderAsync(bool firstRender)
        {
            await base.OnAfterRenderAsync(firstRender);

            if (firstRender)
            {
                await this.LoadData();
            }
        }

        async Task LoadData()
        {
            // delay task to simulate API loading over a network

            await Task.Delay(TimeSpan.FromSeconds(3));

            this.Fields = new List<FieldModel>
            {
                new FieldModel("OrderID", "Order Id", "Number", true, true),
                new FieldModel("Version", "Version", "Number", false, true),
                new FieldModel("CustomerID", "Customer Id", "String", false, true),
                new FieldModel("Freight", "Freight", "Number", false, true),
                new FieldModel("OrderDate", "Order Date", "Date", false, true),
                new FieldModel("ShipCountry", "Ship Country", "String", false, true),
                new FieldModel("Verified", "Verified", "String", false, true),
            };

            Orders = Enumerable.Range(1, 1000).Select((x) =>
            {
                dynamic d = new ExpandoObject();
                d.OrderID = 1000 + x;
                d.Version = x;
                d.CustomerID = (new string[] { "ALFKI", "ANANTR", "ANTON", "BLONP", "BOLID" })[new Random().Next(5)];
                d.Freight = (new double[] { 2, 1, 4, 5, 3 })[new Random().Next(5)] * x;
                d.OrderDate = (new DateTime[] { new DateTime(2010, 11, 5), new DateTime(2018, 10, 3), new DateTime(1995, 9, 9), new DateTime(2012, 8, 2), new DateTime(2015, 4, 11) })[new Random().Next(5)];
                d.ShipCountry = (new string[] { "USA", "UK" })[new Random().Next(2)];
                d.Verified = (new bool[] { true, false })[new Random().Next(2)];

                return d;
            }).Cast<ExpandoObject>().ToList();

            IsLoading = false;

            this.StateHasChanged();
        }

        public class FieldModel
        {
            public bool PrimaryKey { get; }

            public string DataType { get; }

            public string Key { get; }

            public string DisplayName { get; }

            public bool Show { get; }

            public string Format { get; }

            public FieldModel(string key, string displayName, string dataType, bool primaryKey = false, bool show = true, string format = null)
            {
                this.PrimaryKey = primaryKey;
                DataType = dataType;
                Key = key;
                DisplayName = displayName;
                Show = show;
                Format = format;
            }
        }
    }
}