﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace SyncfusionSchedulerChange.Data
{
    public class EventData
    {
        public int Id { get; set; }
        public int UserId { get; set; }
        public int ProjectId { get; set; }
        public string ProjectName { get; set; }
        public string Subject { get; set; }
        public string Subtitle { get; set; }
        public DateTime StartTime { get; set; }
        public DateTime EndTime { get; set; }
    }

    public static class EventDataFactory
    {
        private static List<EventData> Events { get; set; }

        static EventDataFactory()
        {
            Events = new List<EventData>()
            {
                new EventData()
                {
                    Id = 1,
                    UserId = 1,
                    ProjectId = 1,
                    ProjectName = "Project 1",
                    Subject = "Meeting",
                    Subtitle = "Lunch",
                    StartTime = new DateTime(DateTime.Today.Year, DateTime.Today.Month, DateTime.Today.Day, 12, 0, 0),
                    EndTime = new DateTime(DateTime.Today.Year, DateTime.Today.Month, DateTime.Today.Day, 13, 0, 0)
                },
                new EventData()
                {
                    Id = 2,
                    UserId = 2,
                    ProjectId = 2,
                    ProjectName = "Project 2",
                    Subject = "Meeting",
                    Subtitle = "Lunch",
                    StartTime = new DateTime(DateTime.Today.Year, DateTime.Today.Month, DateTime.Today.Day, 12, 0, 0),
                    EndTime = new DateTime(DateTime.Today.Year, DateTime.Today.Month, DateTime.Today.Day, 13, 0, 0)
                },
                new EventData()
                {
                    Id = 3,
                    UserId = 3,
                    ProjectId = 3,
                    ProjectName = "Project 3",
                    Subject = "Meeting",
                    Subtitle = "Lunch",
                    StartTime = new DateTime(DateTime.Today.Year, DateTime.Today.Month, DateTime.Today.Day, 12, 0, 0),
                    EndTime = new DateTime(DateTime.Today.Year, DateTime.Today.Month, DateTime.Today.Day, 13, 0, 0)
                },
            };
        }

        public static List<EventData> GetEvents()
        {
            return Events;
        }

        public static EventData GetEvent(int id)
        {
            return Events.Where(x => x.Id == id).FirstOrDefault();
        }

        public static void UpdateEvent(EventData data)
        {
            var e = Events.Where(x => x.Id == data.Id).FirstOrDefault();

            if (e is null)
                return;

            e.Subject = data.Subject;
            e.ProjectId = data.ProjectId;
            e.ProjectName = data.ProjectName;
        }
    }
}
