import { NgModule, LOCALE_ID} from '@angular/core';
import { CommonModule } from '@angular/common';
import { BOLD_REPORTVIEWER_COMPONENTS } from '@boldreports/angular-reporting-components/src/reportviewer.component';
import '@boldreports/javascript-reporting-controls/Scripts/data-visualization/ej.bulletgraph.min';
import '@boldreports/javascript-reporting-controls/Scripts/data-visualization/ej.chart.min';
import '@boldreports/javascript-reporting-controls/Scripts/data-visualization/ej.circulargauge.min';
import '@boldreports/javascript-reporting-controls/Scripts/data-visualization/ej.lineargauge.min';
import '@boldreports/javascript-reporting-controls/Scripts/data-visualization/ej.map.min';
import '@progress/kendo-angular-intl/locales/de/all';
import '@progress/kendo-angular-intl/locales/es/all';

import { AssetUrlPipe } from 'src/app/shared/pipe/assets.pipe';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { DateInputsModule } from '@progress/kendo-angular-dateinputs';
import { IntlModule } from '@progress/kendo-angular-intl';
import { ComboBoxModule, MultiSelectModule, DropDownListModule } from '@syncfusion/ej2-angular-dropdowns';
import { SioDateReactiveComponent } from 'src/app/shared/forms/components/sio-date-reactive/sio-date-reactive.component';
import { SioDatetimeReactiveComponent } from 'src/app/shared/forms/components/sio-datetime-reactive/sio-datetime-reactive.component';
import { SioTimeReactiveComponent } from 'src/app/shared/forms/components/sio-time-reactive/sio-time-reactive.component';
import { SioMultiselectReactiveComponent } from './forms/components/sio-multiselect-reactive/sio-multiselect-reactive.component';
import { SioComboboxReactiveComponent } from './forms/components/sio-combobox-reactive/sio-combobox-reactive.component';
import { SioComboboxComponent } from './forms/components/sio-combobox/sio-combobox.component';
import { SioRadiobuttonComponent } from './forms/components/sio-radiobutton/sio-radiobutton.component';
import { RadioButtonModule } from '@syncfusion/ej2-angular-buttons';
import { SioEmptyGridComponent } from './components/sio-empty-grid/sio-empty-grid.component';
import { SioUploadFilesComponent } from '@shared/forms/components/sio-upload-files/sio-upload-files.component';
import { UploaderModule  } from '@syncfusion/ej2-angular-inputs';
import { ControlRequiredDirective } from './directives/control-required.directive';
import { SioRoutingChipComponent } from './forms/components/sio-routing-chip/sio-routing-chip.component';
import { TooltipModule, DialogModule } from '@syncfusion/ej2-angular-popups';
import { GridModule, GridAllModule } from '@syncfusion/ej2-angular-grids';
import { SioAttachmentsComponent } from './components/sio-attachments/sio-attachments.component';
@NgModule({
  declarations: [
    BOLD_REPORTVIEWER_COMPONENTS,
    SioDateReactiveComponent,
    SioDatetimeReactiveComponent,
    SioTimeReactiveComponent,
    AssetUrlPipe,
    SioMultiselectReactiveComponent,
    SioComboboxReactiveComponent,
    SioComboboxComponent,
    SioRadiobuttonComponent,
    SioEmptyGridComponent,
    SioUploadFilesComponent,
    ControlRequiredDirective,
    SioRoutingChipComponent,
    SioAttachmentsComponent 
  ],
  imports: [
    CommonModule,
    IntlModule,
    FormsModule,
    ReactiveFormsModule,
    DateInputsModule,
    ComboBoxModule,
    MultiSelectModule,
    DropDownListModule,
    RadioButtonModule,
    UploaderModule,
    TooltipModule,
    GridModule,
    GridAllModule,
    DialogModule
  ],
  exports: [
    BOLD_REPORTVIEWER_COMPONENTS,
    SioDateReactiveComponent,
    SioDatetimeReactiveComponent,
    SioTimeReactiveComponent,
    SioMultiselectReactiveComponent,
    SioComboboxReactiveComponent,
    SioComboboxComponent,
    AssetUrlPipe,
    SioRadiobuttonComponent,
    SioEmptyGridComponent,
    SioUploadFilesComponent,
    ControlRequiredDirective,
    SioRoutingChipComponent,
    SioAttachmentsComponent
  ],
  providers: [
    { provide: LOCALE_ID, useValue: 'es-ES' }
  ]
})
export class SharedModuleModule { }
