import { Injectable, EventEmitter } from '@angular/core';
import Swal from 'sweetalert2';
import { SioNotification } from '../interface/notification.interface';
import { SioAlertModel } from '@shared/model/sio-alert.model';

@Injectable({
  providedIn: 'root'
})
export class SioAlertService {
  public onCreateNotification: EventEmitter<any> = new EventEmitter<any>();

  swalInstance = null;
  
  alert(alertConfig: SioAlertModel) {
      const allowOutsideClick = false;
      this.swalInstance = Swal.fire({
        title: alertConfig.title,
        text: alertConfig.text,
        type: alertConfig.type,
        html: alertConfig.html,
        showCloseButton: alertConfig.showCloseButton,
        showCancelButton: alertConfig.showCancelButton,
        showConfirmButton: alertConfig.showConfirmButton,
        confirmButtonText: alertConfig.confirmButtonText,
        cancelButtonText: alertConfig.cancelButtonText,
        allowOutsideClick
      });
      return this.swalInstance;
  }

  closeAlert() {
    if (this.swalInstance!= undefined && this.swalInstance != null) this.swalInstance.close();
  }

  notifications(notification: SioNotification){
    this.onCreateNotification.emit(notification);
  }
}
