
import { SweetAlertType } from 'sweetalert2';

export class SioAlertModel {
    type: SweetAlertType;
    title: string;
    text: string;
    html: string;
    confirmButtonText: string = 'Aceptar';
    cancelButtonText: string = 'Cerrar';
    showCancelButton: boolean = true;
    showCloseButton: boolean = false;
    showConfirmButton: boolean = false;

    constructor(data: any) {
        this.type = data.type;
        this.title = data.title;
        this.text = data.text;
        if (data.html) this.html = data.html;
        if (data.confirmButtonText != undefined) this.confirmButtonText = data.confirmButtonText;
        if (data.cancelButtonText != undefined) this.cancelButtonText = data.cancelButtonText;
        if (data.showCancelButton != undefined) this.showCancelButton = data.showCancelButton;
        if (data.showCloseButton != undefined) this.showCloseButton = data.showCloseButton;
        if (data.showConfirmButton != undefined) this.showConfirmButton = data.showConfirmButton;
    }
}
