import { Component, OnInit, Input, Output, EventEmitter, ViewChild } from '@angular/core';
import { EmitType, detach, L10n } from '@syncfusion/ej2-base';
import { environment } from '@environments/environment';
import { UploaderComponent, FileInfo, RemovingEventArgs, SelectedEventArgs } from '@syncfusion/ej2-angular-inputs';
import * as _ from 'lodash'
@Component({
  selector: 'sio-upload-files',
  templateUrl: './sio-upload-files.component.html',
  styleUrls: ['./sio-upload-files.component.scss'],
})
export class SioUploadFilesComponent implements OnInit {
  public buttons: Object = {
    browse: 'Buscar archivos',
  };
  public path: Object = {};
  public uploadInputs: [] = [];
  @Input() configUpload: any = {
    allowedExtensions: '.jpg,.png,.jpeg,.svg,.tiff,.pdf,.docx,.doc,.xlsx,.ppt,.pptx',
    maxFileSize: 20971520, // 20MB,
    maximumFilesCount: 10,
    saveUrl: `${environment.base_url}api/Consignment/SaveFilesConsignments`,
    removeUrl: `${environment.base_url}api/Consignment/RemoveFilesConsignments`
  };
  @Input() filesLoaded: any = [];
  @Output() uploads = new EventEmitter<any>(); //Evento para enviar el total archivos exitosos
  @Output() uploadInput = new EventEmitter<any>(); //evento para enviar el valor del input de un formulario

  @Input() title: string = '';
  @ViewChild('defaultupload', { static: false })
  public uploadObj: UploaderComponent;
  customClass: string = "customIcon";

  constructor() { }

  ngOnInit() {
    this.path = {      
      saveUrl: this.configUpload.saveUrl,
      removeUrl: this.configUpload.removeUrl
    }
    L10n.load({
      "es-CH": {
        "uploader": {
          "dropFilesHint": "o arrastre el archivo aquí",
          "uploadSuccessMessage": "El archivo ha subido correctamente",
          "uploadFailedMessage": "El archivo no pudo ser cargado",
          "invalidFileType": (this.configUpload.invalidFileType) ? this.configUpload.invalidFileType : "El tipo de archivo no está permitido",
          "invalidMaxFileSize": "El tamaño del archivo supera el peso máximo",
          "remove": "Eliminar archivo",
          "delete": "Eliminar archivo"
        }
      }
    })

  }

  public onFileSelect: EmitType<Object> = (args: any) => {
    args.filesData.forEach(element => {
      element._id =  _.uniqueId('id-');
    });
    this.uploadInputs = args.filesData;
    this.uploadInput.emit(args.filesData[0]);
    args.filesData.splice(this.configUpload.maximumFilesCount);
    let filesData: FileInfo[] = this.uploadObj.getFilesData();
    let allFiles: FileInfo[] = filesData.concat(args.filesData);

    for (let i: number = 0; i < args.filesData.length; i++) {
      for (let j: number = 0; j < allFiles.length; j++) {
        if (typeof args.filesData[i] != 'undefined' && args.filesData[i]) {
          if (allFiles[j].name == args.filesData[i].name) {
            args.filesData.splice(i, 1);
          }
        }
      }
    }
    allFiles = allFiles.concat(args.filesData);
    args.modifiedFilesData = allFiles;


    if (allFiles.length > this.configUpload.maximumFilesCount) {
      for (let i: number = 0; i < allFiles.length; i++) {
        if (allFiles.length > this.configUpload.maximumFilesCount) {
          allFiles[0]['delete'] = true;
          allFiles[0]['ShowNotMessageMaxCount'] = true;
          this.uploads.emit(allFiles[0]);
          allFiles.shift();          
        }
      }
      args.filesData = allFiles;
      // set the modified custom data
      args.modifiedFilesData = args.filesData;
      this.uploadInputs = args.filesData;
    }    

    args.isModified = true;
  }

  public onFileRemove(args: RemovingEventArgs): void {
    args.postRawFile = true;
    args.filesData[0]['delete'] = true;
    this.uploads.emit(args.filesData[0]);
    this.uploadInput.emit(args.filesData[0])
  }

  public onUploadSuccess: EmitType<Object> = (args: any) => {
    let responseDataUrl = JSON.parse(args.e.target.response);
    if (args.operation === 'upload') {
      responseDataUrl._id = args.file._id;
      this.uploads.emit(responseDataUrl);
    } else {
      args.file.delete = true;
      this.uploads.emit(args.file);      
    }
  }

  clearAll(){
    this.uploadObj.clearAll();
  }
}
