import { async, ComponentFixture, TestBed } from '@angular/core/testing';

import { SioUploadFilesComponent } from './sio-upload-files.component';
import { NO_ERRORS_SCHEMA, CUSTOM_ELEMENTS_SCHEMA } from '@angular/core';
import { RemovingEventArgs } from '@syncfusion/ej2-inputs';

describe('SioUploadFilesComponent', () => {
  let component: SioUploadFilesComponent;
  let fixture: ComponentFixture<SioUploadFilesComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [ SioUploadFilesComponent ],
      schemas: [NO_ERRORS_SCHEMA, CUSTOM_ELEMENTS_SCHEMA]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(SioUploadFilesComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('Should test clearAll', () => {
    const uploadObjObject = jasmine.createSpyObj('UploaderComponent', ['clearAll']);
    component.uploadObj = uploadObjObject;
    component.clearAll();
    expect(component.uploadObj.clearAll).toHaveBeenCalled()
  });

  it('Should test onUploadSuccess', () => {
    spyOn(component.uploads,'emit');
    const args = {file:{_id:'123'} , operation:'upload', e:{target:{response:JSON.stringify({id:'1',value:'test'})}}} 
    component.onUploadSuccess(args);
    expect(component.uploads.emit).toHaveBeenCalled();
  })

  it('Should test onUploadSuccess not upload', () => {
    spyOn(component.uploads,'emit');
    const args = {file:{_id:'123', delete: false} , operation:'xyz', e:{target:{response:JSON.stringify({id:'1',value:'test'})}}} 
    component.onUploadSuccess(args);
    expect(component.uploads.emit).toHaveBeenCalled();
  })

  it('Should test onFileRemove', () => {
    let args: RemovingEventArgs = {postRawFile:true, cancel:null, customFormData:null, event:null, filesData:[]}
    spyOn(component.uploads,'emit');
    spyOn(component.uploadInput,'emit');
    args['postRawFile'] = false;
    args['filesData'] = [{statusCode:null, name:null, size:null, type:null ,rawFile:null,  status:null, validationMessages:null}]
    args['filesData'][0]['delete'] = false;
    component.onFileRemove(args)
    expect(component.uploads.emit).toHaveBeenCalled()
  })

  it('Should test onFileSelct', () => {
    let args = {filesData:[{_id:'1'},{_id:'2'}]}
    component.configUpload.maximumFilesCount = 1;
    const uploadObjObject = jasmine.createSpyObj('UploaderComponent', ['getFilesData']);
    component.uploadObj = uploadObjObject;
    component.uploadObj.getFilesData = () => []
    component.configUpload['maximumFilesCount'] = -1;
    component.onFileSelect(args);
    expect(component.uploadInputs).not.toBeNull()
  })
});
