import { Component, Input, Output, EventEmitter, ViewEncapsulation, forwardRef } from '@angular/core';
import { ControlValueAccessor, NG_VALUE_ACCESSOR } from '@angular/forms';
import { IntlService } from '@progress/kendo-angular-intl';

@Component({
  selector: 'sio-time-reactive',
  templateUrl: './sio-time-reactive.component.html',
  styleUrls: ['./sio-time-reactive.component.scss'],
  encapsulation: ViewEncapsulation.None,
  providers: [
    {
        provide: NG_VALUE_ACCESSOR,
        useExisting: forwardRef(() => SioTimeReactiveComponent),
        multi: true
    }
  ]
})
export class SioTimeReactiveComponent implements ControlValueAccessor {

   // Attributes
   @Input() placeholder: string = 'HH:mm';
   @Input() format: string = 'HH:mm';
   @Input() isDisabled: boolean;
   @Input() isReadOnly: boolean;
   @Input() rangeValidation: boolean;
   @Input() min;
   @Input() max;
   @Input() disabledDates: [];
   // Events
   @Output() onChanges = new EventEmitter();
   @Output() getTime = new EventEmitter<Date>();
   @Output() getString = new EventEmitter<String>();
 
 
   value: any;
   
   
   private changeDate = (_: any) => {};
   private onTouched() {}
 

   constructor(private intl: IntlService){}

   registerOnChange(fn: any): void {
       this.changeDate = fn;
   }
   registerOnTouched(fn: any): void {
     this.onTouched = fn;
   }
   setDisabledState(isDisabled: boolean): void {
     this.isDisabled = isDisabled;
   }
   selectDate(item): void {
     this.value = item;
     this.changeDate(item);   
     this.onChange(item);
   }
   writeValue(obj: any): void {
     this.value = obj;
   }
 
   onChange(event){
     this.getTime.emit(event);
     this.getString.emit(this.formatDateDirectriz(event));
     this.onChanges.emit(event);
   }
 
   // Event trigger
   get getFormat() {
     return this.format;
   }
 
   formatDateDirectriz(date) {
    var value = new Date(date);
    return value ? `${this.intl.formatDate(value, this.getFormat)}` : '';
   }

}

