import { Component, OnInit, Input, EventEmitter, Output, ViewChild } from '@angular/core';
import { RadioButton } from '@syncfusion/ej2-buttons';

@Component({
  selector: 'sio-radiobutton',
  templateUrl: './sio-radiobutton.component.html',
  styleUrls: ['./sio-radiobutton.component.scss']
})
export class SioRadiobuttonComponent implements OnInit {

  @Input() checked: boolean;
  @Input() disabled: boolean;
  @Input() label: string;
  @Input() name: string;
  @Input() cssClass: string;
  @Output() change = new EventEmitter();

  @ViewChild('sioradiobutton', {static: false}) 
  radiobutton: RadioButton;

  constructor() { }

  ngOnInit() {}

  onChangeRadio(){
    this.change.emit(this.radiobutton);
  }
}
